/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.Session;
import org.opcfoundation.ua.application.SessionChannel;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.CreateSessionRequest;
import org.opcfoundation.ua.core.CreateSessionResponse;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.FindServersRequest;
import org.opcfoundation.ua.core.FindServersResponse;
import org.opcfoundation.ua.core.GetEndpointsRequest;
import org.opcfoundation.ua.core.GetEndpointsResponse;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.ChannelService;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.ServiceChannel;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.https.HttpsClient;
import org.opcfoundation.ua.transport.https.HttpsClientSecureChannel;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.io.OpcTcpSettings;
import org.opcfoundation.ua.transport.tcp.io.SecureChannelTcp;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    Logger logger = LoggerFactory.getLogger(Client.class);
    Application application;
    EndpointConfiguration endpointConfiguration = EndpointConfiguration.defaults();

    public static Client createClientApplication(KeyPair keyPair) {
        Application application = new Application();
        Client client = new Client(application);
        if (keyPair != null) {
            try {
                String string = CertificateUtils.getApplicationUriOfCertificate(keyPair.certificate);
                application.setApplicationUri(string);
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            application.addApplicationInstanceCertificate(keyPair);
            application.getHttpsSettings().setKeyPair(keyPair, new Cert[0]);
        }
        return client;
    }

    public Client(Application application) {
        this.application = application;
    }

    public ApplicationDescription createApplicationDescription() {
        ApplicationDescription applicationDescription = this.application.applicationDescription.clone();
        applicationDescription.setApplicationType(ApplicationType.Client);
        return applicationDescription;
    }

    public Application getApplication() {
        return this.application;
    }

    public HttpsSettings getApplicationHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public OpcTcpSettings getApplicatioOpcTcpSettings() {
        return this.application.getOpctcpSettings();
    }

    public Session createSession(SecureChannel secureChannel) throws ServiceResultException {
        return this.createSession(secureChannel, null, null, null);
    }

    public Session createSession(SecureChannel secureChannel, UnsignedInteger unsignedInteger, Double d, String string) throws IllegalArgumentException, ServiceResultException {
        return this.createSession(secureChannel, unsignedInteger, d, string, null);
    }

    public Session createSession(SecureChannel secureChannel, UnsignedInteger unsignedInteger, Double d, String string, EndpointDescription[] endpointDescriptionArray) throws IllegalArgumentException, ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2;
        Object object;
        EndpointDescription[] endpointDescriptionArray3;
        if (unsignedInteger == null) {
            unsignedInteger = UnsignedInteger.valueOf(0x400000L);
        }
        if (d == null) {
            d = 3600000.0;
        }
        EndpointDescription endpointDescription = secureChannel.getEndpointDescription();
        Client client = this;
        if (endpointDescription == null || secureChannel == null) {
            throw new IllegalArgumentException("null arg");
        }
        Session session = new Session();
        if (string == null) {
            string = UUID.randomUUID() + "-" + String.format("%08X", System.identityHashCode(session));
        }
        session.endpoint = endpointDescription;
        session.name = string;
        KeyPair keyPair = client.application.getApplicationInstanceCertificate();
        if (keyPair != null && secureChannel.getEndpointDescription().needsCertificate()) {
            session.clientCertificate = keyPair.getCertificate();
            session.clientPrivateKey = keyPair.getPrivateKey();
        }
        session.clientNonce = CryptoUtil.createNonce(32);
        CreateSessionRequest createSessionRequest = new CreateSessionRequest();
        createSessionRequest.setClientNonce(session.clientNonce);
        createSessionRequest.setClientDescription(client.createApplicationDescription());
        if (session.clientCertificate != null) {
            createSessionRequest.setClientCertificate(session.getClientCertificate().getEncoded());
        }
        createSessionRequest.setEndpointUrl(endpointDescription.getEndpointUrl());
        createSessionRequest.setMaxResponseMessageSize(unsignedInteger);
        if (endpointDescription.getServer() != null) {
            createSessionRequest.setServerUri(endpointDescription.getServer().getApplicationUri());
        }
        createSessionRequest.setSessionName(session.name);
        createSessionRequest.setRequestedSessionTimeout(d);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setTimestamp(DateTime.currentTime());
        createSessionRequest.setRequestHeader(requestHeader);
        CreateSessionResponse createSessionResponse = (CreateSessionResponse)secureChannel.serviceRequest(createSessionRequest);
        byte[] byArray = createSessionResponse.getServerCertificate();
        session.serverCertificate = byArray == null || byArray.length == 0 ? null : new Cert(byArray);
        session.serverNonce = createSessionResponse.getServerNonce();
        session.sessionId = createSessionResponse.getSessionId();
        session.authenticationToken = createSessionResponse.getAuthenticationToken();
        session.sessionTimeout = createSessionResponse.getRevisedSessionTimeout();
        session.maxRequestMessageSize = createSessionResponse.getMaxRequestMessageSize();
        session.serverSoftwareCertificates = createSessionResponse.getServerSoftwareCertificates();
        this.logger.debug("MessageSecurityMode: {}", (Object)secureChannel.getMessageSecurityMode());
        if (!MessageSecurityMode.None.equals(secureChannel.getMessageSecurityMode())) {
            endpointDescriptionArray3 = createSessionResponse.getServerSignature();
            object = ByteBufferUtils.concatenate(createSessionRequest.getClientCertificate(), session.clientNonce);
            endpointDescriptionArray2 = endpointDescriptionArray3 == null ? null : endpointDescriptionArray3.getAlgorithm();
            this.logger.debug("Algorithm: {}", (Object)endpointDescriptionArray2);
            SecurityAlgorithm securityAlgorithm = SecurityAlgorithm.valueOfUri((String)endpointDescriptionArray2);
            boolean bl = CryptoUtil.getCryptoProvider().verifyAsymm(session.serverCertificate.getCertificate().getPublicKey(), securityAlgorithm, (byte[])object, endpointDescriptionArray3.getSignature());
            if (!bl) {
                throw new ServiceResultException(StatusCodes.Bad_ApplicationSignatureInvalid, "The signature generated with the server certificate is missing or invalid.");
            }
        }
        if ((endpointDescriptionArray3 = createSessionResponse.getServerEndpoints()) == null || endpointDescriptionArray3.length == 0) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The CreateSessionResponse's endpoint list received from the server is empty");
        }
        object = secureChannel.getEndpointDescription().getTransportProfileUri();
        this.validateEndpoints((String)object, endpointDescriptionArray3, endpointDescriptionArray);
        endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray3, endpointDescription.getEndpointUrl(), null, endpointDescription.getSecurityMode(), SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), endpointDescription.getServerCertificate());
        if (endpointDescriptionArray2.length == 0 && endpointDescriptionArray == null) {
            endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray3, null, null, endpointDescription.getSecurityMode(), SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), endpointDescription.getServerCertificate());
        }
        if (endpointDescriptionArray2.length == 0) {
            this.logger.error("Requested endpoint is not found on the server: Endpoint={}", (Object)endpointDescription);
            this.logger.debug("endpoints={}", Arrays.asList(endpointDescriptionArray3));
            throw new ServiceResultException(StatusCodes.Bad_SecurityModeRejected, "Requested endpoint is not found on the server");
        }
        if (endpointDescriptionArray2.length == 1) {
            session.endpoint = endpointDescriptionArray2[0];
        }
        return session;
    }

    public SessionChannel createSessionChannel(String string) throws ServiceResultException {
        return this.createSessionChannel(string, string);
    }

    public SessionChannel createSessionChannel(String string, String string2) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints(string, string);
        EndpointDescription endpointDescription = EndpointUtil.select(endpointDescriptionArray, string2);
        SecureChannel secureChannel = this.createSecureChannel(string, endpointDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public SessionChannel createSessionChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return this.createSessionChannel(endpointDescription.getEndpointUrl(), endpointDescription);
    }

    public SessionChannel createSessionChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(string, endpointDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public SessionChannel createSessionChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(applicationDescription);
        try {
            Session session = this.createSession(secureChannel);
            SessionChannel sessionChannel = session.createSessionChannel(secureChannel, this);
            return sessionChannel;
        }
        catch (ServiceResultException serviceResultException) {
            secureChannel.closeAsync();
            throw serviceResultException;
        }
    }

    public SecureChannel createSecureChannel(String string) throws ServiceResultException {
        return this.createSecureChannel(string, string);
    }

    public SecureChannel createSecureChannel(String string, String string2) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints(string, "");
        EndpointDescription endpointDescription = EndpointUtil.select(endpointDescriptionArray, string);
        return this.createSecureChannel(string, endpointDescription);
    }

    public SecureChannel createSecureChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        String[] stringArray = applicationDescription.getDiscoveryUrls();
        if (stringArray == null || stringArray.length == 0) {
            throw new ServiceResultException("application description does not contain any discovery url");
        }
        for (String string : stringArray) {
            if (!string.toLowerCase().startsWith("opc.tcp")) continue;
            SecureChannel secureChannel = this.createSecureChannel(string, string);
            return secureChannel;
        }
        for (String string : stringArray) {
            if (!string.toLowerCase().startsWith("https")) continue;
            SecureChannel secureChannel = this.createSecureChannel(string, string);
            return secureChannel;
        }
        throw new ServiceResultException("No suitable discover url was found");
    }

    public SecureChannel createSecureChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return this.createSecureChannel(endpointDescription.getEndpointUrl(), endpointDescription);
    }

    public SecureChannel createSecureChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
        transportChannelSettings.setDescription(endpointDescription);
        return this.createSecureChannel(string, transportChannelSettings);
    }

    public SecureChannel createSecureChannel(String string, String string2, SecurityMode securityMode, Cert cert) throws ServiceResultException {
        Cert cert2;
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.setEndpointUrl(string2);
        endpointDescription.setSecurityMode(securityMode.getMessageSecurityMode());
        endpointDescription.setSecurityPolicyUri(securityMode.getSecurityPolicy().getPolicyUri());
        Cert cert3 = cert2 = securityMode.getMessageSecurityMode() == MessageSecurityMode.None ? null : cert;
        if (cert2 != null) {
            endpointDescription.setServerCertificate(cert2.getEncoded());
        }
        return this.createSecureChannel(string, endpointDescription);
    }

    public SecureChannel createSecureChannel(String string, TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        UriUtil.MessageFormat messageFormat = UriUtil.getMessageFormat(string);
        if (messageFormat == UriUtil.MessageFormat.Binary) {
            KeyPair keyPair;
            SecureChannel secureChannel = this.createSecureChannelImpl(string);
            TransportChannelSettings transportChannelSettings2 = new TransportChannelSettings();
            transportChannelSettings2.setConfiguration(this.endpointConfiguration);
            transportChannelSettings2.getHttpsSettings().readFrom(this.application.getHttpsSettings());
            transportChannelSettings2.getOpctcpSettings().readFrom(this.application.getOpctcpSettings());
            if (transportChannelSettings != null) {
                transportChannelSettings2.readFrom(transportChannelSettings);
            }
            if ((keyPair = this.application.getApplicationInstanceCertificate()) != null && transportChannelSettings2.getDescription().needsCertificate()) {
                transportChannelSettings2.getOpctcpSettings().setPrivKey(keyPair.getPrivateKey());
                transportChannelSettings2.getOpctcpSettings().setClientCertificate(keyPair.getCertificate());
            }
            try {
                secureChannel.initialize(string, transportChannelSettings2, this.getEncoderContext());
                secureChannel.open();
                return secureChannel;
            }
            catch (ServiceResultException serviceResultException) {
                secureChannel.dispose();
                throw serviceResultException;
            }
        }
        throw new ServiceResultException("Unsupported protocol " + (Object)((Object)messageFormat));
    }

    public SecureChannel createSecureChannel(TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        return this.createSecureChannel(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings);
    }

    public ServiceChannel createServiceChannel(String string) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string));
    }

    public ServiceChannel createServiceChannel(String string, String string2) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string2));
    }

    public ServiceChannel createServiceChannel(ApplicationDescription applicationDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(applicationDescription));
    }

    public ServiceChannel createServiceChannel(EndpointDescription endpointDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(endpointDescription.getEndpointUrl(), endpointDescription));
    }

    public ServiceChannel createServiceChannel(String string, EndpointDescription endpointDescription) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, endpointDescription));
    }

    public ServiceChannel createServiceChannel(String string, String string2, SecurityMode securityMode, Cert cert) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(string, string2, securityMode, cert));
    }

    public ServiceChannel createServiceChannel(TransportChannelSettings transportChannelSettings) throws ServiceResultException {
        return new ServiceChannel(this.createSecureChannel(transportChannelSettings));
    }

    public EndpointDescription[] discoverEndpoints(String string) throws ServiceResultException {
        return this.discoverEndpoints(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDescription[] discoverEndpoints(String string, String string2) throws ServiceResultException {
        SecureChannel secureChannel = this.createSecureChannel(string, string2, SecurityMode.NONE, null);
        ChannelService channelService = new ChannelService(secureChannel);
        try {
            EndpointDescription[] endpointDescriptionArray;
            GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(null, string2, new String[0], new String[0]);
            getEndpointsRequest.setRequestHeader(new RequestHeader());
            getEndpointsRequest.getRequestHeader().setTimeoutHint(UnsignedInteger.valueOf(this.getTimeout()));
            GetEndpointsResponse getEndpointsResponse = channelService.GetEndpoints(getEndpointsRequest);
            EndpointDescription[] endpointDescriptionArray2 = endpointDescriptionArray = getEndpointsResponse.getEndpoints();
            return endpointDescriptionArray2;
        }
        finally {
            secureChannel.close();
            secureChannel.dispose();
        }
    }

    public ApplicationDescription[] discoverApplications(String string) throws ServiceResultException {
        return this.discoverApplications(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationDescription[] discoverApplications(String string, String string2) throws ServiceResultException {
        SecurityMode securityMode = SecurityMode.NONE;
        SecureChannel secureChannel = this.createSecureChannel(string, string2, securityMode, null);
        ChannelService channelService = new ChannelService(secureChannel);
        try {
            FindServersRequest findServersRequest = new FindServersRequest(null, string2, new String[0], new String[0]);
            findServersRequest.setRequestHeader(new RequestHeader());
            findServersRequest.getRequestHeader().setTimeoutHint(UnsignedInteger.valueOf(this.getTimeout()));
            FindServersResponse findServersResponse = channelService.FindServers(findServersRequest);
            ApplicationDescription[] applicationDescriptionArray = findServersResponse.getServers();
            return applicationDescriptionArray;
        }
        finally {
            secureChannel.close();
            secureChannel.dispose();
        }
    }

    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    SecureChannel createSecureChannelImpl(String string) throws ServiceResultException {
        String string2 = UriUtil.getTransportProtocol(string);
        if (string2.equals("opc.tcp")) {
            SecureChannelTcp secureChannelTcp = new SecureChannelTcp();
            return secureChannelTcp;
        }
        if (string2.equals("https")) {
            HttpsClient httpsClient = new HttpsClient(string2);
            HttpsClientSecureChannel httpsClientSecureChannel = new HttpsClientSecureChannel(httpsClient);
            return httpsClientSecureChannel;
        }
        if (string2.equals("http")) {
            HttpsClient httpsClient = new HttpsClient(string2);
            HttpsClientSecureChannel httpsClientSecureChannel = new HttpsClientSecureChannel(httpsClient);
            return httpsClientSecureChannel;
        }
        throw new ServiceResultException("Unsupported protocol: " + string2);
    }

    public void setTimeout(int n) {
        this.endpointConfiguration.setOperationTimeout(n);
    }

    public int getTimeout() {
        return this.endpointConfiguration.getOperationTimeout();
    }

    public void setMaxMessageSize(int n) {
        this.endpointConfiguration.setMaxMessageSize(n);
    }

    public int getMaxMessageSize() {
        return this.endpointConfiguration.getMaxMessageSize();
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    private void validateEndpoints(String string, EndpointDescription[] endpointDescriptionArray, EndpointDescription[] endpointDescriptionArray2) throws ServiceResultException {
        if (endpointDescriptionArray2 == null) {
            return;
        }
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray2) {
            EndpointDescription endpointDescription2 = endpointDescription.clone();
            endpointDescription2.setServer(null);
            endpointDescription2.setServerCertificate(null);
            arrayList.add(endpointDescription2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (EndpointDescription endpointDescription2 : endpointDescriptionArray) {
            EndpointDescription endpointDescription = endpointDescription2.clone();
            endpointDescription.setServer(null);
            endpointDescription.setServerCertificate(null);
            arrayList2.add(endpointDescription);
        }
        for (EndpointDescription endpointDescription : arrayList) {
            if (arrayList2.contains(endpointDescription)) continue;
            this.logger.error("The endpoint received from GetEndpoints is not in the endpoints of CreateSessionResponse. Endpoint={}", (Object)endpointDescription);
            this.logger.debug("GetEndpoints returned endpoints={}", arrayList);
            this.logger.debug("CreateSessionResponse endpoints={}", (Object)arrayList2);
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The endpoint received from GetEndpoints is not in the endpoints of CreateSessionResponse");
        }
    }
}

