/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import cta.acs.opcua.da.UaDataSupport;
import java.math.BigInteger;
import java.util.logging.Level;

public class UaDataSupportUInt64
extends UaDataSupport {
    public UaDataSupportUInt64(String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(serverURI, nodeIdRef);
    }

    @Override
    public BigInteger get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof UnsignedLong) {
            return ((UnsignedLong)value).bigIntegerValue();
        }
        this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected result type: " + value.getClass());
        if (value instanceof UnsignedInteger) {
            return BigInteger.valueOf(((UnsignedInteger)value).longValue());
        }
        if (value instanceof UnsignedShort) {
            return BigInteger.valueOf(((UnsignedShort)value).longValue());
        }
        if (value instanceof UnsignedByte) {
            return BigInteger.valueOf(((UnsignedByte)value).longValue());
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof BigInteger) {
                super.set(UnsignedLong.valueOf((BigInteger)((BigInteger)value)), completionHolder);
                return;
            }
            this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected argument type: " + value.getClass());
            if (value instanceof Long) {
                super.set(UnsignedLong.valueOf((long)((Long)value)), completionHolder);
                return;
            } else if (value instanceof Integer) {
                super.set(UnsignedLong.valueOf((long)((Integer)value).longValue()), completionHolder);
                return;
            } else if (value instanceof Short) {
                super.set(UnsignedLong.valueOf((long)((Short)value).longValue()), completionHolder);
                return;
            } else {
                if (!(value instanceof Byte)) throw this.generateDefaultAcsException("Set <" + value + "> failed: unsupported type " + value.getClass(), completionHolder);
                super.set(UnsignedLong.valueOf((long)((Byte)value).longValue()), completionHolder);
            }
            return;
        } else {
            super.set(null, completionHolder);
        }
    }
}

