/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import cta.acs.opcua.da.UaDataSupport;
import org.apache.commons.lang.ArrayUtils;

public class UaDataSupportLongs
extends UaDataSupport {
    public UaDataSupportLongs(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public long[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return new long[]{(Long)value};
        }
        if (value instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])value));
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            long[] resValues = new long[values.length];
            int i = 0;
            while (i < values.length) {
                Object obj = values[i];
                if (obj != null) {
                    if (!(obj instanceof Long)) {
                        throw this.generateDefaultAcsException("Get failed: unexpected type " + obj.getClass(), completionHolder);
                    }
                    resValues[i] = (Long)obj;
                }
                ++i;
            }
            return resValues;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof Long[]) {
                super.set(value, completionHolder);
            } else if (value instanceof long[]) {
                super.set(ArrayUtils.toObject((long[])((long[])value)), completionHolder);
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                Long[] values = new Long[objects.length];
                int i = 0;
                while (i < values.length) {
                    Object obj = objects[i];
                    if (obj != null) {
                        if (!(obj instanceof Long)) {
                            throw this.generateDefaultAcsException("Set <" + obj + "> failed: unexpected type " + obj.getClass(), completionHolder);
                        }
                        values[i] = (Long)obj;
                    }
                    ++i;
                }
            }
            throw this.generateDefaultAcsException("Set <" + value + "> failed: unexpected type " + value.getClass(), completionHolder);
        }
        super.set(null, completionHolder);
    }
}

