/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da.extension;

import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import cta.acs.opcua.da.UaDataSupport;
import java.util.logging.Level;
import org.apache.commons.lang.ArrayUtils;

public class UaDataSupportByteString
extends UaDataSupport {
    public UaDataSupportByteString(String serverURI, String nodeIdRef) throws IllegalArgumentException {
        super(serverURI, nodeIdRef);
    }

    public byte[] get(CompletionHolder completionHolder) throws AcsJException {
        Object value = super.get(completionHolder);
        if (value == null) {
            return null;
        }
        if (value instanceof ByteString) {
            return ((ByteString)value).getValue();
        }
        if (value instanceof byte[]) {
            this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " unexpected result type: " + value.getClass());
            return (byte[])value;
        }
        throw this.generateDefaultAcsException("Get failed: unexpected type " + value.getClass(), completionHolder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        if (value != null) {
            if (value instanceof byte[]) {
                super.set(ByteString.valueOf((byte[])((byte[])value)), completionHolder);
                return;
            } else {
                if (!(value instanceof Byte[])) throw this.generateDefaultAcsException("Set <" + value + "> failed: unsupported type " + value.getClass(), completionHolder);
                super.set(ByteString.valueOf((byte[])ArrayUtils.toPrimitive((Byte[])((Byte[])value))), completionHolder);
            }
            return;
        } else {
            super.set(null, completionHolder);
        }
    }
}

