/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import alma.ACS.jbaci.CompletionUtil;
import alma.ACS.jbaci.DataAccess;
import alma.ACSErr.CompletionHolder;
import alma.acs.exceptions.AcsJException;
import alma.acs.exceptions.DefaultAcsJException;
import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import cta.acs.opcua.da.AbstractMonitoringSupport;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;

public class UaDataSupport
extends AbstractMonitoringSupport
implements DataAccess<Object> {
    private final Vector<DataAccess.ValueChangeListener> valueChangeListeners = new Vector();
    protected Object uaValue;
    boolean isDataChangeEvent = false;
    boolean isGettingPriorValue = false;
    private boolean isConversionToPrimitiveArrayEnabled = false;
    private boolean isPriorValueEnabled = true;

    public UaDataSupport(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public UaDataSupport(UaClient client, String ... nodeIdRefs) {
        super(client, nodeIdRefs);
    }

    public static String dataValueToString(DataValue value) {
        StringBuilder sb = new StringBuilder("Status: ");
        sb.append(value.getStatusCode());
        if (value.getStatusCode().isNotBad()) {
            sb.append(" | Value: ");
            if (value.isNull()) {
                sb.append("NULL");
            } else {
                Variant variant = value.getValue();
                variant.getCompositeClass();
                Object v = value.getValue().getValue();
                if (value.getValue().isArray()) {
                    sb.append(MultiDimensionArrayUtils.toString((Object)v));
                } else {
                    sb.append(v);
                }
            }
        }
        sb.append(UaDataSupport.dateTimeToString(" | ServerTimestamp: ", value.getServerTimestamp(), value.getServerPicoseconds()));
        sb.append(UaDataSupport.dateTimeToString(" | SourceTimestamp: ", value.getSourceTimestamp(), value.getSourcePicoseconds()));
        return sb.toString();
    }

    public static String dataValueToString(UaClient client, NodeId nodeId, UnsignedInteger attributeId, DataValue value, boolean showReadValueDataType) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node: ").append(nodeId);
        sb.append(".").append(AttributesUtil.toString((UnsignedInteger)attributeId));
        sb.append(" | Status: ").append(value.getStatusCode());
        if (value.getStatusCode().isGood()) {
            if (!value.isNull()) {
                Variant variant = value.getValue();
                sb.append(" | Class: ");
                sb.append(variant == null ? "unknown" : variant.getCompositeClass());
                Object v = variant == null ? null : variant.getValue();
                sb.append(" | Value: ");
                sb.append(v == null ? "null" : (variant.isArray() ? MultiDimensionArrayUtils.toString((Object)v) : v.toString()));
                if (showReadValueDataType) {
                    try {
                        UaNode node = client.getAddressSpace().getNode(nodeId);
                        UaDataType dataType = null;
                        if (node != null && node instanceof UaVariable) {
                            UaVariable valiable = (UaVariable)client.getAddressSpace().getNode(nodeId);
                            dataType = valiable.getDataType();
                            if (dataType != null) {
                                sb.append(" | DataType: " + dataType.getDisplayName().getText());
                            } else {
                                NodeId dataTypeId = valiable.getDataTypeId();
                                dataType = client.getAddressSpace().getType(dataTypeId);
                                if (dataType != null) {
                                    sb.append(" | DataType: " + dataType.getDisplayName().getText());
                                } else if (dataTypeId != null) {
                                    sb.append(" | DataTypeId: " + dataTypeId);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                sb.append("NULL");
            }
        }
        sb.append(UaDataSupport.dateTimeToString(" | ServerTimestamp: ", value.getServerTimestamp(), value.getServerPicoseconds()));
        sb.append(UaDataSupport.dateTimeToString(" | SourceTimestamp: ", value.getSourceTimestamp(), value.getSourcePicoseconds()));
        return sb.toString();
    }

    private static String dateTimeToString(String title, DateTime timestamp, UnsignedShort picoSeconds) {
        if (timestamp != null && !timestamp.equals((Object)DateTime.MIN_VALUE)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy MMM dd (zzz) HH:mm:ss.SSS");
            StringBuilder sb = new StringBuilder(title);
            sb.append(format.format(timestamp.getCalendar(TimeZone.getDefault()).getTime()));
            if (picoSeconds != null && !picoSeconds.equals((Object)UnsignedShort.valueOf((int)0))) {
                sb.append(String.format("/%d picos", picoSeconds.getValue()));
            }
            return sb.toString();
        }
        return "";
    }

    public Object get(CompletionHolder completionHolder) throws AcsJException {
        int cntNodes = this.countNodes();
        int cntObs = this.countObservers();
        if (this.isDataChangeEvent || this.isGettingPriorValue || this.isCacheEnabled() && (this.isSubscribed() || cntObs > 0)) {
            if (this.uaValue == null && cntNodes > 1) {
                this.uaValue = new Object[cntNodes];
            } else if (this.isConversionToPrimitiveArrayEnabled) {
                this.uaValue = this.convertToPrimitiveArray(this.uaValue);
            }
            this.generateNoErrorCompletion(completionHolder);
            this.m_logger.log((Level)AcsLogLevel.TRACE, String.valueOf(this.getNodeIdRefsAsStr()) + " Return value(s): " + this.uaValue);
            return this.uaValue;
        }
        try {
            this.getSync();
            this.generateNoErrorCompletion(completionHolder);
            return this.uaValue;
        }
        catch (DefaultAcsJException acsException) {
            this.generateErrorCompletion(completionHolder, (AcsJException)acsException);
            throw acsException;
        }
        catch (Exception e) {
            throw this.generateDefaultAcsException("Get failed: " + e.getMessage(), completionHolder);
        }
    }

    public Object getSync() throws AcsJException {
        this.m_logger.log((Level)AcsLogLevel.TRACE, String.valueOf(this.getNodeIdRefsAsStr()) + " Executing getSync() ... ");
        this.uaValue = this.countNodes() == 1 ? this.readValue() : this.readValues();
        return this.uaValue;
    }

    public void set(Object value, CompletionHolder completionHolder) throws AcsJException {
        try {
            if (this.countNodes() == 1) {
                this.writeValue(value);
            } else {
                this.writeValues((Object[])value);
            }
            this.generateNoErrorCompletion(completionHolder);
        }
        catch (DefaultAcsJException acsException) {
            this.generateErrorCompletion(completionHolder, (AcsJException)acsException);
            throw acsException;
        }
        catch (Exception e) {
            throw this.generateDefaultAcsException("Set failed: " + e.getMessage(), completionHolder);
        }
    }

    private Object readValue() throws AcsJException {
        NodeId nodeId = this.getNodeIds()[0];
        DataValue dataValue = null;
        try {
            dataValue = this.getUaClient().readValue(nodeId);
            if (dataValue == null) {
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: data is NULL!");
            }
        }
        catch (IOException e) {
            throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            StatusCode s = e.getServiceResult();
            if (s != null) {
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: " + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription(), e);
            }
            throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: " + e.getMessage(), e);
        }
        catch (StatusException e) {
            StatusCode s = e.getStatusCode();
            if (s != null) {
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: " + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription(), e);
            }
            throw new UaDataSupportAcsJException("[ " + nodeId + "] Read value failed: " + e.getMessage(), e);
        }
        StatusCode status = dataValue.getStatusCode();
        if (!status.isGood()) {
            String errDesc = status.getDescription();
            String msg = "[ " + nodeId + "] Read failed: " + errDesc;
            UnsignedInteger statusValue = status.getValue();
            throw new UaDataSupportAcsJException(msg, status.getInfotype(), statusValue == null ? status.getSubcode() : statusValue.intValue(), errDesc);
        }
        if (dataValue.isNull()) {
            return null;
        }
        Variant variant = dataValue.getValue();
        if (variant == null) {
            return null;
        }
        Object value = variant.getValue();
        return this.isConversionToPrimitiveArrayEnabled && variant.isArray() ? this.convertToPrimitiveArray(value) : value;
    }

    protected Object convertToPrimitiveArray(Object v) {
        if (this.countNodes() == 1 && v instanceof Object[]) {
            Object[] a = (Object[])v;
            Object r = this.toPrimitiveArray(a);
            this.m_logger.log((Level)AcsLogLevel.TRACE, v.getClass() + " converted to primitives " + r.getClass() + ": " + Arrays.toString(a));
            return r;
        }
        return v;
    }

    protected Object toPrimitiveArray(Object[] array) throws IllegalArgumentException {
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Converting array " + array.getClass() + " to primitive array ... ");
        int length = 0;
        if (array == null || (length = array.length) == 0) {
            return null;
        }
        Object obj = array[0];
        if (obj instanceof Byte) {
            byte[] res = new byte[length];
            int i = 0;
            while (i < length) {
                res[i] = (Byte)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Short) {
            short[] res = new short[length];
            int i = 0;
            while (i < length) {
                res[i] = (Short)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Integer) {
            int[] res = new int[length];
            int i = 0;
            while (i < length) {
                res[i] = (Integer)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Long) {
            long[] res = new long[length];
            int i = 0;
            while (i < length) {
                res[i] = (Long)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Float) {
            float[] res = new float[length];
            int i = 0;
            while (i < length) {
                res[i] = ((Float)array[i]).floatValue();
                ++i;
            }
            return res;
        }
        if (obj instanceof Double) {
            double[] res = new double[length];
            int i = 0;
            while (i < length) {
                res[i] = (Double)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Boolean) {
            boolean[] res = new boolean[length];
            int i = 0;
            while (i < length) {
                res[i] = (Boolean)array[i];
                ++i;
            }
            return res;
        }
        if (obj instanceof Character) {
            char[] res = new char[length];
            int i = 0;
            while (i < length) {
                res[i] = ((Character)array[i]).charValue();
                ++i;
            }
            return res;
        }
        return array;
    }

    protected Object[] toObjectArray(Object array) {
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Converting " + array.getClass() + " to object array ... ");
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        int length = Array.getLength(array);
        if (array instanceof byte[]) {
            Object[] res = new Byte[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getByte(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof short[]) {
            Object[] res = new Short[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getShort(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof int[]) {
            Object[] res = new Integer[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getInt(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof long[]) {
            Object[] res = new Long[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getLong(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof float[]) {
            Object[] res = new Float[length];
            int i = 0;
            while (i < length) {
                res[i] = Float.valueOf(Array.getFloat(array, i));
                ++i;
            }
            return res;
        }
        if (array instanceof double[]) {
            Object[] res = new Double[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getDouble(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof boolean[]) {
            Object[] res = new Boolean[length];
            int i = 0;
            while (i < length) {
                res[i] = Array.getBoolean(array, i);
                ++i;
            }
            return res;
        }
        if (array instanceof char[]) {
            Object[] res = new Character[length];
            int i = 0;
            while (i < length) {
                res[i] = Character.valueOf(Array.getChar(array, i));
                ++i;
            }
            return res;
        }
        Object[] ret = new Object[length];
        int i = 0;
        while (i < length) {
            ret[i] = Array.get(array, i);
            ++i;
        }
        return ret;
    }

    private Object readValues() throws AcsJException {
        DataValue[] dataValues;
        NodeId[] nodeIds = this.getNodeIds();
        try {
            dataValues = this.getUaClient().readValues(nodeIds, TimestampsToReturn.Both);
            if (dataValues == null) {
                throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Read values failed: data array is NULL!");
            }
        }
        catch (IOException e) {
            throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Read values failed: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            StatusCode s = e.getServiceResult();
            if (s != null) {
                throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Read values failed" + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription(), e);
            }
            throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Read values failed: " + e.getMessage(), e);
        }
        Object[] values = new Object[dataValues.length];
        int i = 0;
        while (i < values.length) {
            DataValue dataValue = dataValues[i];
            if (dataValue != null) {
                StatusCode status = dataValue.getStatusCode();
                if (!status.isGood()) {
                    UnsignedInteger statusValue = status.getValue();
                    this.onReadError(this.nodeIdRefs[i], status.getInfotype(), statusValue == null ? status.getSubcode() : statusValue.intValue(), status.getDescription());
                }
                values[i] = dataValue.isNull() ? null : dataValue.getValue().getValue();
            }
            ++i;
        }
        return values;
    }

    private void writeValue(Object value) throws DefaultAcsJException {
        block19: {
            NodeId nodeId = this.getNodeIds()[0];
            try {
                this.m_logger.log((Level)AcsLogLevel.TRACE, "Writing <" + value + "> to node " + nodeId + " ... ");
                if (value == null) {
                    throw new NullPointerException("value is null");
                }
                Variant val = value;
                if (this.isConversionToPrimitiveArrayEnabled && value.getClass().isArray()) {
                    Variant res = this.toObjectArray(value);
                    this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + value.getClass() + "] object array is converted to primitive array [" + res.getClass() + "]: " + Arrays.toString((Object[])res));
                    val = res;
                }
                Boolean status = null;
                try {
                    status = this.writeValue(nodeId, val);
                }
                catch (StatusException e) {
                    this.m_logger.log((Level)AcsLogLevel.WARNING, "[ " + nodeId + "] Write <" + val + "> failed with StatusExpection: " + e.getMessage());
                    StatusCode s = e.getStatusCode();
                    if (s != null && StatusCodes.Bad_TypeMismatch.equals((Object)s.getValue())) {
                        ExpandedNodeId expandedNodeId;
                        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Converting " + val.getClass() + " to correspondent OPC UA data type ...");
                        AddressSpace space = this.getUaClient().getAddressSpace();
                        UaNode node = null;
                        try {
                            node = space.getNode(nodeId);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (node == null && (expandedNodeId = space.getNamespaceTable().toExpandedNodeId(nodeId)) != null) {
                            node = space.getNode(expandedNodeId);
                        }
                        if (node != null) {
                            UaDataType dataType = null;
                            if (node instanceof UaVariable) {
                                UaVariable variable = (UaVariable)node;
                                if (variable.getDataType() == null) {
                                    variable.setDataType(space.getDataType(variable.getDataTypeId()));
                                }
                                dataType = variable.getDataType();
                                this.m_logger.log((Level)AcsLogLevel.DEBUG, "[" + nodeId + "] DataType: " + (dataType == null ? "unknown" : dataType.getDisplayName().getText()));
                            }
                            val = this.isConversionToPrimitiveArrayEnabled() && dataType.inheritsFrom(Identifiers.ByteString) ? value : (dataType != null ? space.getDataTypeConverter().parseVariant(value.toString(), dataType) : value);
                            status = this.getUaClient().writeValue(nodeId, (Object)val);
                            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Write <" + val + "> (" + val.getClass().getSimpleName() + ") to node " + nodeId + (status == null ? "" : (status != false ? " - OK" : " ... completes asynchronously")));
                        } else {
                            status = this.writeValue(nodeId, val);
                        }
                        break block19;
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed: " + e.getMessage(), e);
            }
            catch (ServiceException e) {
                StatusCode s = e.getServiceResult();
                if (s != null) {
                    throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed" + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription(), e);
                }
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed: " + e.getMessage(), e);
            }
            catch (StatusException e) {
                StatusCode s = e.getStatusCode();
                if (s != null) {
                    throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed" + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription());
                }
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new UaDataSupportAcsJException("[ " + nodeId + "] Write <" + value + "> failed: " + e.getMessage(), e);
            }
        }
    }

    protected Boolean writeValue(NodeId nodeId, Object value) throws ServiceException, StatusException, IOException {
        Boolean status = this.getUaClient().writeValue(nodeId, value);
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Write <" + value + "> (" + value.getClass().getSimpleName() + ") to node " + nodeId + (status == null ? "" : (status != false ? " - OK" : " ... completes asynchronously")));
        return status;
    }

    private void writeValues(Object[] values) throws AcsJException {
        StatusCode[] statusCodes;
        try {
            statusCodes = this.getUaClient().writeValues(this.getNodeIds(), values);
            if (statusCodes == null) {
                throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write failed: status array is NULL!");
            }
        }
        catch (IOException e) {
            throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write <" + Arrays.asList(values) + "> failed: " + e.getMessage(), e);
        }
        catch (ServiceException e) {
            StatusCode s = e.getServiceResult();
            if (s != null) {
                throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write <" + Arrays.asList(values) + "> failed" + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription());
            }
            throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write <" + Arrays.asList(values) + "> failed: " + e.getMessage(), e);
        }
        catch (StatusException e) {
            StatusCode s = e.getStatusCode();
            if (s != null) {
                throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write <" + Arrays.asList(values) + "> failed" + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription());
            }
            throw new UaDataSupportAcsJException(String.valueOf(this.getNodeIdRefsAsStr()) + " Write <" + Arrays.asList(values) + "> failed: " + e.getMessage(), e);
        }
        int i = 0;
        while (i < statusCodes.length) {
            StatusCode status = statusCodes[i];
            if (!status.isGood()) {
                UnsignedInteger statusValue = status.getValue();
                this.onWriteError(this.nodeIdRefs[i], status.getInfotype(), statusValue == null ? status.getSubcode() : statusValue.intValue(), status.getDescription());
            } else {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, "[" + this.nodeIdRefs[i] + "] Writing <" + values[i] + "> - OK");
            }
            ++i;
        }
    }

    public boolean isConversionToPrimitiveArrayEnabled() {
        return this.isConversionToPrimitiveArrayEnabled;
    }

    public void setConversionToPrimitiveArrayEnabled(boolean enabled) {
        this.isConversionToPrimitiveArrayEnabled = enabled;
    }

    public boolean isPriorValueEnabled() {
        return this.isPriorValueEnabled;
    }

    public void setPriorValueEnabled(boolean enabled) {
        this.isPriorValueEnabled = enabled;
    }

    protected DefaultAcsJException generateDefaultAcsException(String errorMessage, CompletionHolder completionHolder) {
        UaDataSupportAcsJException acsException = new UaDataSupportAcsJException(errorMessage, this.getNodeIdRefsAsStr());
        this.generateErrorCompletion(completionHolder, (AcsJException)acsException);
        return acsException;
    }

    protected void generateNoErrorCompletion(CompletionHolder completionHolder) {
        if (completionHolder != null) {
            completionHolder.value = CompletionUtil.generateNoErrorCompletion();
        }
    }

    protected void generateErrorCompletion(CompletionHolder completionHolder, AcsJException acsException) {
        if (completionHolder != null) {
            completionHolder.value = CompletionUtil.generateCompletion((AcsJException)acsException);
        }
    }

    protected void onReadError(String nodeIdRef, int errorType, int errorCode, String errorDescription) throws AcsJException {
        String msg = "[ " + nodeIdRef + "] Read failed: " + errorDescription;
        this.m_logger.log((Level)AcsLogLevel.TRACE, msg);
        throw new DefaultAcsJException(msg, errorType, errorCode, errorDescription);
    }

    protected void onWriteError(String nodeIdRef, int errorType, int errorCode, String errorDescription) throws AcsJException {
        String msg = "[ " + nodeIdRef + "] Write failed: " + errorDescription;
        this.m_logger.log((Level)AcsLogLevel.TRACE, msg);
        throw new DefaultAcsJException(msg, errorType, errorCode, errorDescription);
    }

    public boolean initializeValue() {
        return false;
    }

    public synchronized int countObservers() {
        return this.valueChangeListeners.size();
    }

    public synchronized void addValueChangeListener(DataAccess.ValueChangeListener listener) throws DataAccess.OnChangeNotSupportedException {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        if (!this.valueChangeListeners.contains(listener)) {
            try {
                this.subscribe();
                this.valueChangeListeners.addElement(listener);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public synchronized void removeValueChangeListener(DataAccess.ValueChangeListener listener) {
        this.valueChangeListeners.removeElement(listener);
        if (this.valueChangeListeners.isEmpty()) {
            try {
                this.unsubscribe();
            }
            catch (Exception e) {
                this.m_logger.log((Level)AcsLogLevel.WARNING, "Remove subscription failed", (Throwable)e);
            }
        }
    }

    protected synchronized void notify(Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        for (DataAccess.ValueChangeListener listener : this.valueChangeListeners) {
            listener.valueChanged((DataAccess)this, oldValue, newValue);
        }
    }

    protected void onValueChange(String nodeIdRef, Object oldValue, Object newValue) throws AcsJException {
        Object oldConverted = null;
        if (this.isPriorValueEnabled) {
            this.isGettingPriorValue = true;
            oldConverted = this.getPriorValue();
            this.isGettingPriorValue = false;
        }
        this.setUaValue(nodeIdRef, newValue);
        this.notify(oldConverted, this.get(null));
    }

    private void setUaValue(String nodeIdRef, Object uaVal) throws NullPointerException, IllegalArgumentException {
        if (this.countNodes() == 1) {
            this.uaValue = uaVal;
        } else {
            if (this.uaValue == null) {
                this.uaValue = new Object[this.countNodes()];
            }
            ((Object[])this.uaValue)[this.getNodeIndex((String)nodeIdRef)] = uaVal;
        }
    }

    private Object getPriorValue() throws AcsJException {
        Object value = this.get(null);
        if (value != null && value.getClass().isArray()) {
            Class<?> type = value.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return ((Object[])value).clone();
            }
            int length = Array.getLength(value);
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((boolean[])value, length);
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((byte[])value, length);
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((int[])value, length);
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((long[])value, length);
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((double[])value, length);
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((float[])value, length);
            }
            if (Character.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((char[])value, length);
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return Arrays.copyOf((short[])value, length);
            }
        }
        return value;
    }

    protected void onValueChangeError(String nodeIdRef, AcsJException exception) {
        this.m_logger.log((Level)AcsLogLevel.ERROR, "[" + nodeIdRef + "]", (Throwable)exception);
    }

    @Override
    protected MonitoredItem createMonitoringItem(NodeId nodeId) throws IOException {
        String nodeIdRef = nodeId.toString();
        this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeIdRef + "] Getting/Creating monitoring item ...");
        Subscription subscription = this.getSubscription();
        MonitoredDataItem item = null;
        if (!subscription.hasItem(nodeId, Attributes.Value)) {
            this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeIdRef + "] Creating monitoring item ...");
            item = new MonitoredDataItem(nodeId, Attributes.Value, MonitoringMode.Reporting);
            long queueSize = this.getQueueSize();
            if (item.getQueueSize() != queueSize) {
                this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeIdRef + "] Setting QueueSize from <" + item.getQueueSize() + "> to <" + queueSize + "> ...");
                try {
                    item.setQueueSize(queueSize);
                }
                catch (ServiceException e) {
                    throw new IOException("Set QueueSize <" + queueSize + "> failed" + e.getMessage(), e);
                }
            }
            double samplingInterval = this.getSamplingInterval();
            if (item.getSamplingInterval() != samplingInterval) {
                this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeIdRef + "] Setting SamplingInterval from <" + item.getSamplingInterval() + "> to <" + samplingInterval + "> ...");
                try {
                    item.setSamplingInterval(samplingInterval);
                }
                catch (ServiceException e) {
                    throw new IOException("Set sampling interval <" + samplingInterval + "> failed" + e.getMessage(), e);
                }
            }
            item.setDataChangeListener((MonitoredDataItemListener)new MonitoredDataItemHandler(nodeIdRef));
        }
        return item;
    }

    @Override
    public void close() throws IOException {
        this.valueChangeListeners.removeAllElements();
        super.close();
    }

    private final class MonitoredDataItemHandler
    implements MonitoredDataItemListener {
        final String nodeIdRef;

        MonitoredDataItemHandler(String nodeIdRef) {
            this.nodeIdRef = nodeIdRef;
        }

        public void onDataChange(MonitoredDataItem sender, DataValue prevValue, DataValue dataValue) {
            NodeId senderNodeId = sender.getNodeId();
            if (senderNodeId == null || !this.nodeIdRef.equals(senderNodeId.toString())) {
                UaDataSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, "unexpected sender nodeId: " + senderNodeId);
                return;
            }
            UaDataSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, "[DATA CHANGED] " + UaDataSupport.dataValueToString(sender.getSubscription().getClient(), senderNodeId, sender.getAttributeId(), dataValue, true));
            try {
                UaDataSupport.this.isDataChangeEvent = true;
                UaDataSupport.this.onValueChange(this.nodeIdRef, this.getValue(prevValue), this.getValue(dataValue));
                UaDataSupport.this.isDataChangeEvent = false;
            }
            catch (StatusException e) {
                StatusCode s = e.getStatusCode();
                UaDataSupport.this.onValueChangeError(this.nodeIdRef, (AcsJException)new UaDataSupportAcsJException("[" + this.nodeIdRef + "] Data change failure: " + e.getMessage(), s.getInfotype(), s.getSubcode(), s.getDescription(), e));
            }
            catch (Throwable e) {
                UaDataSupport.this.onValueChangeError(this.nodeIdRef, (AcsJException)new UaDataSupportAcsJException("[" + this.nodeIdRef + "] Data change error: " + e.getMessage(), e));
            }
        }

        private Object getValue(DataValue dataValue) throws StatusException {
            if (dataValue == null) {
                return null;
            }
            StatusCode status = dataValue.getStatusCode();
            if (!status.isGood()) {
                throw new StatusException(status);
            }
            return dataValue.isNull() ? null : dataValue.getValue().getValue();
        }
    }

    protected class UaDataSupportAcsJException
    extends DefaultAcsJException {
        private static final long serialVersionUID = 1L;
        private static final int DEFAULT_ERROR_TYPE = 101;
        private static final int DEFAULT_ERROR_CODE = 101;

        public UaDataSupportAcsJException(String message, int errType, int errCode, String shortDescription, Throwable e) {
            super(message, errType, errCode, shortDescription, e == null ? null : e.getClass().getName());
            UaDataSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, message);
        }

        public UaDataSupportAcsJException(String message) {
            this(message, 101, 101, null, null);
        }

        public UaDataSupportAcsJException(String message, String shortDescription) {
            this(message, 101, 101, shortDescription, null);
        }

        public UaDataSupportAcsJException(String message, Throwable e) {
            this(message, 101, 101, null, e);
        }

        public UaDataSupportAcsJException(String message, int errType, int errCode, String shortDescription) {
            this(message, 101, 101, shortDescription, null);
        }
    }
}

