/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.ContentFilterBuilder;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredEventItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.ElementOperand;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.stack.core.FilterOperator;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.LiteralOperand;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import cta.acs.opcua.da.AbstractMonitoringSupport;
import java.io.IOException;
import java.util.logging.Level;

public class UaAlarmSupport
extends AbstractMonitoringSupport {
    private static final int INDEX_MESSAGE = 1;
    private static final int INDEX_SOURCE = 2;
    private static final int INDEX_TIME = 3;
    private static final int INDEX_SEVERITY = 4;
    private static final int INDEX_ACTIVE_STATE = 5;
    private static final QualifiedName[] EVENT_FIELDS = new QualifiedName[]{new QualifiedName("EventType"), new QualifiedName("Message"), new QualifiedName("SourceName"), new QualifiedName("Time"), new QualifiedName("Severity"), new QualifiedName("ActiveState/Id")};
    private EventFilter eventFilter;

    public UaAlarmSupport(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public void onEvent(String nodeIdRef, String message, String source, Long timestamp, Integer severity, Boolean activeState) {
        this.m_logger.log((Level)AcsLogLevel.INFO, "[" + nodeIdRef + "]: " + message);
    }

    @Override
    public MonitoredItem createMonitoringItem(NodeId nodeId) throws IOException {
        Subscription subscription = this.getSubscription();
        MonitoredEventItem item = null;
        if (!subscription.hasItem(nodeId, Attributes.EventNotifier)) {
            item = new MonitoredEventItem(nodeId, this.getFilter());
            item.setEventListener((MonitoredEventItemListener)new MonitoredEventItemHandler(nodeId.toString()));
        }
        return item;
    }

    private EventFilter getFilter() throws IOException {
        if (this.eventFilter == null) {
            this.eventFilter = this.createEventFilter();
        }
        return this.eventFilter;
    }

    private EventFilter createEventFilter() throws IOException {
        NodeId eventTypeId = Identifiers.BaseEventType;
        UnsignedInteger eventAttributeId = Attributes.Value;
        String indexRange = null;
        SimpleAttributeOperand[] selectClauses = new SimpleAttributeOperand[EVENT_FIELDS.length + 1];
        int i = 0;
        while (i < EVENT_FIELDS.length) {
            QualifiedName[] browsePath = this.createBrowsePath(EVENT_FIELDS[i]);
            selectClauses[i] = new SimpleAttributeOperand(eventTypeId, browsePath, eventAttributeId, indexRange);
            ++i;
        }
        selectClauses[UaAlarmSupport.EVENT_FIELDS.length] = new SimpleAttributeOperand(eventTypeId, null, Attributes.NodeId, null);
        EventFilter filter = new EventFilter();
        filter.setSelectClauses(selectClauses);
        ContentFilterBuilder fb = new ContentFilterBuilder();
        fb.add(FilterOperator.Not, new FilterOperand[]{new ElementOperand(UnsignedInteger.valueOf((long)1L))});
        LiteralOperand filteredType = new LiteralOperand((Object)new Variant((Object)Identifiers.GeneralModelChangeEventType));
        fb.add(FilterOperator.OfType, new FilterOperand[]{filteredType});
        filter.setWhereClause(fb.getContentFilter());
        return filter;
    }

    private QualifiedName[] createBrowsePath(QualifiedName qualifiedName) {
        if (!qualifiedName.getName().contains("/")) {
            return new QualifiedName[]{qualifiedName};
        }
        int namespaceIndex = qualifiedName.getNamespaceIndex();
        String[] names = qualifiedName.getName().split("/");
        QualifiedName[] result = new QualifiedName[names.length];
        int i = 0;
        while (i < names.length) {
            result[i] = new QualifiedName(namespaceIndex, names[i]);
            ++i;
        }
        return result;
    }

    private final class MonitoredEventItemHandler
    implements MonitoredEventItemListener {
        final String nodeIdRef;

        MonitoredEventItemHandler(String nodeIdRef) {
            this.nodeIdRef = nodeIdRef;
        }

        public void onEvent(MonitoredEventItem sender, Variant[] eventFields) {
            UaAlarmSupport.this.m_logger.log((Level)AcsLogLevel.DEBUG, this.eventToString(eventFields));
            NodeId senderNodeId = sender.getNodeId();
            if (senderNodeId == null || !this.nodeIdRef.equals(senderNodeId.toString())) {
                UaAlarmSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, "unexpected sender nodeId: " + senderNodeId);
                return;
            }
            UaAlarmSupport.this.onEvent(this.nodeIdRef, this.getMessage(eventFields), this.getSource(eventFields), this.getTimestamp(eventFields), this.getSeverity(eventFields), this.getActiveState(eventFields));
        }

        private String getMessage(Variant[] eventFields) {
            if (eventFields.length <= 1) {
                return null;
            }
            Variant variant = eventFields[1];
            if (variant == null) {
                return null;
            }
            Object value = variant.getValue();
            return value == null ? null : value.toString();
        }

        private String getSource(Variant[] eventFields) {
            if (eventFields.length <= 2) {
                return null;
            }
            Variant variant = eventFields[2];
            return variant == null ? null : (String)variant.getValue();
        }

        private Long getTimestamp(Variant[] eventFields) {
            if (eventFields.length <= 3) {
                return null;
            }
            Variant variant = eventFields[3];
            if (variant == null) {
                return null;
            }
            Object value = variant.getValue();
            return value == null ? null : Long.valueOf(((DateTime)value).getMilliSeconds());
        }

        private Integer getSeverity(Variant[] eventFields) {
            if (eventFields.length <= 4) {
                return null;
            }
            Variant variant = eventFields[4];
            if (variant == null) {
                return null;
            }
            Object value = variant.getValue();
            return value == null ? null : Integer.valueOf(((UnsignedShort)value).intValue());
        }

        private Boolean getActiveState(Variant[] eventFields) {
            if (eventFields.length <= 5) {
                return null;
            }
            Variant variant = eventFields[5];
            return variant == null ? null : (Boolean)variant.getValue();
        }

        private String eventFieldsToString(Variant[] fieldValues) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < fieldValues.length) {
                Object fieldValue = fieldValues[i] == null ? null : fieldValues[i].getValue();
                try {
                    AddressSpace space = UaAlarmSupport.this.getUaClient().getAddressSpace();
                    UaNode node = null;
                    if (fieldValue instanceof NodeId) {
                        node = space.getNode((NodeId)fieldValue);
                    } else if (fieldValue instanceof ExpandedNodeId) {
                        node = space.getNode((ExpandedNodeId)fieldValue);
                    }
                    if (node != null) {
                        fieldValue = String.format("%s {%s}", node.getBrowseName(), fieldValue);
                    }
                }
                catch (Exception space) {
                    // empty catch block
                }
                if (i < EVENT_FIELDS.length) {
                    QualifiedName fieldName = EVENT_FIELDS[i];
                    sb.append(String.valueOf(fieldName.getName()) + "=" + fieldValue + "; ");
                } else {
                    sb.append("Node=" + fieldValue + "; ");
                }
                ++i;
            }
            return sb.toString();
        }

        private String eventToString(Variant[] fieldValues) {
            return String.format("Node: \"%s\", Fields: %s", this.nodeIdRef, this.eventFieldsToString(fieldValues));
        }
    }
}

