/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.CallMethodResult;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractResultListener {
    private AsyncResult<CallResponse> result;

    protected abstract void onCompleted(Object[] var1);

    protected abstract void onError(IOException var1);

    void setAsyncResult(AsyncResult<CallResponse> result) {
        this.result = result;
        this.result.setListener((ResultListener)new ResultListener<CallResponse>(){

            public void onError(ServiceResultException error) {
                AbstractResultListener.this.onError(error == null ? null : new IOException(error.getMessage()));
            }

            public void onCompleted(CallResponse response) {
                if (response != null) {
                    if (response instanceof CallResponse) {
                        CallMethodResult[] callMethodResults = response.getResults();
                        if (callMethodResults != null && callMethodResults.length != 0) {
                            if (callMethodResults.length == 1) {
                                CallMethodResult callMethodResult = callMethodResults[0];
                                if (callMethodResult != null) {
                                    Object[] outputArguments = callMethodResult.getOutputArguments();
                                    if (outputArguments != null && outputArguments.length > 0) {
                                        AbstractResultListener.this.onCompleted(outputArguments);
                                    } else {
                                        AbstractResultListener.this.onCompleted(new Object[0]);
                                    }
                                } else {
                                    AbstractResultListener.this.onCompleted(new Object[0]);
                                }
                            } else {
                                AbstractResultListener.this.onError(new IOException("unexpected result size: " + callMethodResults.length));
                            }
                        } else {
                            AbstractResultListener.this.onCompleted(new Object[0]);
                        }
                    } else {
                        AbstractResultListener.this.onError(new IOException("unexpected response class: " + response.getClass()));
                    }
                } else {
                    AbstractResultListener.this.onCompleted(null);
                }
            }
        });
    }

    public IOException getError() throws IllegalStateException {
        if (this.result == null) {
            throw new IllegalStateException("async result is not initialized");
        }
        ServiceResultException resultException = this.result.getError();
        if (resultException == null) {
            return null;
        }
        if (resultException.getStatusCode() == null) {
            throw new IllegalStateException("status code is Null!");
        }
        if (!resultException.getStatusCode().isGood()) {
            return new IOException(resultException.getMessage());
        }
        return null;
    }

    public Object getResult() throws IOException, IllegalStateException {
        if (this.result == null) {
            throw new IllegalStateException("async result is not initialized");
        }
        try {
            return this.result.getResult();
        }
        catch (ServiceResultException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Object waitForResult() throws IOException, TimeoutException, IllegalStateException {
        if (this.result == null) {
            throw new IllegalStateException("async result is not initialized");
        }
        try {
            return this.result.waitForResult();
        }
        catch (ServiceResultException e) {
            StatusCode status = e.getStatusCode();
            if (status != null && status.isStatusCode(StatusCodes.Bad_Timeout)) {
                throw new TimeoutException(e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    public Object waitForResult(long timeout, TimeUnit unit) throws IOException, TimeoutException, IllegalStateException {
        if (this.result == null) {
            throw new IllegalStateException("async result is not initialized");
        }
        try {
            return this.result.waitForResult(timeout, unit);
        }
        catch (ServiceResultException e) {
            StatusCode status = e.getStatusCode();
            if (status != null && status.isStatusCode(StatusCodes.Bad_Timeout)) {
                throw new TimeoutException(e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }
}

