/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import alma.acs.logging.AcsLogLevel;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.NotificationData;
import cta.acs.opcua.da.AbstractDataAccess;
import cta.acs.opcua.da.UaSubscriptionListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Level;

public abstract class AbstractMonitoringSupport
extends AbstractDataAccess {
    private Subscription subscription;
    private double publishingInterval = 1000.0;
    private double samplingInterval = -1.0;
    private long queueSize = 1L;
    private long maxKeepAliveCount = 20L;
    private long lifetimeCount = 60L;
    private UaSubscriptionListener notificationListener;
    private SubscriptionAliveHandler subscriptionAliveListener;
    private SubscriptionNotificationHandler subscriptionNotificationListener;
    private boolean isCacheEnabled = true;

    public AbstractMonitoringSupport(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        super(serverURI, nodeIdRefs);
    }

    public AbstractMonitoringSupport(UaClient client, String ... nodeIdRefs) {
        super(client, nodeIdRefs);
    }

    protected abstract MonitoredItem createMonitoringItem(NodeId var1) throws IOException;

    public void setPublishingEnabled(boolean enabled) throws IOException {
        if (enabled || this.isSubscribed()) {
            try {
                this.getSubscription().setPublishingEnabled(enabled);
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(enabled ? "Enable" : "Disable") + " publishing [" + this.subscription.getSubscriptionId() + "] failed: " + e.getMessage(), e);
            }
        } else {
            this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " Disable publishing for subscription failed: data monitoring item(s) are not initialized.");
        }
    }

    public void subscribe() throws IOException {
        NodeId[] nodeIds;
        NodeId[] nodeIdArray = nodeIds = this.getNodeIds();
        int n = nodeIds.length;
        int n2 = 0;
        while (n2 < n) {
            NodeId nodeId = nodeIdArray[n2];
            MonitoredItem item = this.createMonitoringItem(nodeId);
            this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeId + "] Adding monitoring item: " + item + " ...");
            if (item != null) {
                Subscription subscription = this.getSubscription();
                this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeId + "] Subscription (size= " + subscription.getItemCount() + "): " + subscription);
                try {
                    if (subscription.getItemCount() == 0 || subscription.getItem(nodeId, Attributes.Value) == null) {
                        this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeId + "] adding item: " + item);
                        subscription.addItem(item);
                        this.m_logger.log((Level)AcsLogLevel.TRACE, "[" + nodeId + "] Monitoring item added to subscription <" + subscription.getSubscriptionId() + "> with id: " + item.getMonitoredItemId());
                    }
                }
                catch (Exception e) {
                    throw new IOException("Add monitoring item [ " + item + "] failed: " + e.getMessage(), e);
                }
            }
            ++n2;
        }
        this.adjustNotificationListener(this.notificationListener);
        this.setPublishingEnabled(true);
    }

    public void unsubscribe() throws IOException {
        MonitoredItemBase[] items;
        if (this.subscription == null) {
            return;
        }
        try {
            this.subscription.setPublishingEnabled(false);
        }
        catch (Exception e) {
            throw new IOException("Disable publishing [" + this.subscription.getSubscriptionId() + "] failed: " + e.getMessage(), e);
        }
        this.adjustNotificationListener(null);
        try {
            this.subscription.removeItems();
        }
        catch (Exception e) {
            this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " Remove monitoring items failed: " + e.getMessage());
        }
        MonitoredItemBase[] monitoredItemBaseArray = items = this.subscription.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MonitoredItemBase item = monitoredItemBaseArray[n2];
            try {
                this.subscription.removeItem(item);
                this.m_logger.log((Level)AcsLogLevel.TRACE, String.valueOf(this.getNodeIdRefsAsStr()) + " Monitoring item <" + item.getMonitoredItemId() + "> removed from subscription <" + this.subscription.getSubscriptionId() + ">.");
            }
            catch (Exception e) {
                this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(this.getNodeIdRefsAsStr()) + " Remove monitoring item <" + item.getMonitoredItemId() + "> error: " + e.getMessage());
            }
            ++n2;
        }
        try {
            try {
                this.m_logger.log((Level)AcsLogLevel.DEBUG, String.valueOf(this.getNodeIdRefsAsStr()) + " Removing subscription <" + this.subscription.getSubscriptionId() + "> ...");
                this.getUaClient().removeSubscription(this.subscription);
            }
            catch (ServiceException e) {
                throw new IOException(String.valueOf(this.getNodeIdRefsAsStr()) + " Remove subscription [" + this.subscription.getSubscriptionId() + "] failed: " + e.getMessage(), e);
            }
        }
        finally {
            this.subscription = null;
        }
    }

    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.getItemCount() != 0;
    }

    public double getPublishingInterval() {
        return this.publishingInterval;
    }

    public void setPublishingInterval(double requestedPublishingInterval) throws IOException {
        if (requestedPublishingInterval <= 0.0) {
            throw new IllegalArgumentException("parameter must be positiv.");
        }
        if (this.isSubscribed()) {
            throw new IOException("Set publishing interval [ " + requestedPublishingInterval + "] failed: data monitoring item(s) already initialized.");
        }
        this.publishingInterval = requestedPublishingInterval;
    }

    public double getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(double requestedSamplingInterval) throws IOException {
        if (this.isSubscribed()) {
            throw new IOException("Set sampling interval [ " + this.samplingInterval + "] failed: data monitoring item(s) already initialized.");
        }
        this.samplingInterval = requestedSamplingInterval;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(long requestedQueueSize) throws IOException {
        if (requestedQueueSize < 0L) {
            throw new IllegalArgumentException("parameter must in the range of unsigned integer.");
        }
        if (this.isSubscribed()) {
            throw new IOException("Set queue size [ " + requestedQueueSize + "] failed: data monitoring item(s) already initialized");
        }
        this.queueSize = requestedQueueSize;
    }

    public long getMaxKeepAliveCount() {
        return this.maxKeepAliveCount;
    }

    public void setMaxKeepAliveCount(long requestedMaxKeepAliveCount) throws IOException {
        if (requestedMaxKeepAliveCount <= 0L) {
            throw new IllegalArgumentException("parameter must be positiv.");
        }
        if (this.isSubscribed()) {
            throw new IOException("Set max keep alive count [ " + requestedMaxKeepAliveCount + "] failed: data monitoring item(s) already initialized");
        }
        this.maxKeepAliveCount = requestedMaxKeepAliveCount;
    }

    public long getLifetimeCount() {
        return this.lifetimeCount;
    }

    public void setLifetimeCount(long requestedLifetimeCount) throws IOException {
        if (requestedLifetimeCount < 0L) {
            throw new IllegalArgumentException("parameter must in the range of unsigned integer.");
        }
        if (this.isSubscribed()) {
            throw new IOException("Set lifetime count [ " + requestedLifetimeCount + "] failed: data monitoring item(s) already initialized");
        }
        this.lifetimeCount = requestedLifetimeCount;
    }

    protected void adjustNotificationListener(UaSubscriptionListener notificationListener) {
        if (this.subscription != null) {
            if (notificationListener == null && this.subscriptionAliveListener != null) {
                this.subscription.removeAliveListener((SubscriptionAliveListener)this.subscriptionAliveListener);
                this.subscriptionAliveListener = null;
            } else if (notificationListener != null && this.subscriptionAliveListener == null) {
                this.subscriptionAliveListener = new SubscriptionAliveHandler();
                this.subscription.addAliveListener((SubscriptionAliveListener)this.subscriptionAliveListener);
            }
            if (notificationListener == null && this.subscriptionNotificationListener != null) {
                this.subscription.removeNotificationListener((SubscriptionNotificationListener)this.subscriptionNotificationListener);
                this.subscriptionNotificationListener = null;
            } else if (notificationListener != null && this.subscriptionNotificationListener == null) {
                this.subscriptionNotificationListener = new SubscriptionNotificationHandler();
                this.subscription.addNotificationListener((SubscriptionNotificationListener)this.subscriptionNotificationListener);
            }
        }
    }

    public UaSubscriptionListener getNotificationListener() {
        return this.notificationListener;
    }

    public void setNotificationListener(UaSubscriptionListener notificationListener) {
        this.notificationListener = notificationListener;
        this.adjustNotificationListener(notificationListener);
    }

    Subscription getSubscription() throws IOException {
        if (this.subscription == null) {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, String.valueOf(this.getNodeIdRefsAsStr()) + " Creating subscription ...");
            this.subscription = new Subscription();
            try {
                this.subscription.setPublishingInterval(this.publishingInterval);
                this.subscription.setMaxKeepAliveCount(this.maxKeepAliveCount);
                this.subscription.setLifetimeCount(this.lifetimeCount);
                this.adjustNotificationListener(this.notificationListener);
            }
            catch (ServiceException e) {
                throw new IOException("Configure subscription failed: " + e.getMessage(), e);
            }
            if (!this.getUaClient().hasSubscription(this.subscription.getSubscriptionId())) {
                try {
                    this.getUaClient().addSubscription(this.subscription);
                    this.m_logger.log((Level)AcsLogLevel.DEBUG, String.valueOf(this.getNodeIdRefsAsStr()) + " Subscription <" + this.subscription.getSubscriptionId() + "> added.");
                }
                catch (Exception e) {
                    throw new IOException("Add subscription [ " + this.subscription + "] failed: " + e.getMessage(), e);
                }
            }
        }
        return this.subscription;
    }

    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    public void setCacheEnabled(boolean isCacheEnabled) {
        this.isCacheEnabled = isCacheEnabled;
    }

    @Override
    public void close() throws IOException {
        this.unsubscribe();
        super.close();
    }

    private final class SubscriptionAliveHandler
    implements SubscriptionAliveListener {
        private SubscriptionAliveHandler() {
        }

        public void onAfterCreate(Subscription s) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, String.format("%tc Subscription created: ID=%d lastAlive=%tc", Calendar.getInstance(), s.getSubscriptionId().getValue(), s.getLastAlive()));
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onAfterCreate();
            }
        }

        public void onAlive(Subscription s) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, String.format("%tc Subscription alive: ID=%d lastAlive=%tc", Calendar.getInstance(), s.getSubscriptionId().getValue(), s.getLastAlive()));
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onAlive();
            }
        }

        public void onLifetimeTimeout(Subscription s) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, String.format("%tc Subscription lifetime ended: ID=%d lastAlive=%tc", Calendar.getInstance(), s.getSubscriptionId().getValue(), s.getLastAlive()));
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onLifetimeTimeout();
            }
        }

        public void onTimeout(Subscription s) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, String.format("%tc Subscription timeout: ID=%d lastAlive=%tc", Calendar.getInstance(), s.getSubscriptionId().getValue(), s.getLastAlive()));
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onTimeout();
            }
        }
    }

    private final class SubscriptionNotificationHandler
    implements SubscriptionNotificationListener {
        private SubscriptionNotificationHandler() {
        }

        public void onBufferOverflow(Subscription subscription, UnsignedInteger sequenceNumber, ExtensionObject[] notificationData) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(AbstractMonitoringSupport.this.getNodeIdRefsAsStr()) + " Subcription buffer overflow, the oldest/discarded sequence number in the buffer = " + sequenceNumber);
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onBufferOverflow(sequenceNumber.longValue());
            }
        }

        public void onDataChange(Subscription subscription, MonitoredDataItem item, DataValue newValue) {
        }

        public void onError(Subscription subscription, Object notification, Exception exception) {
            AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, String.valueOf(AbstractMonitoringSupport.this.getNodeIdRefsAsStr()) + " On error: " + exception.getMessage());
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onError(exception);
            }
        }

        public void onEvent(Subscription subscription, MonitoredEventItem item, Variant[] eventFields) {
        }

        public long onMissingData(Subscription subscription, UnsignedInteger lastSequenceNumber, long sequenceNumber, long newSequenceNumber, StatusCode serviceResult) {
            if (AbstractMonitoringSupport.this.m_logger != null) {
                AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.WARNING, "Data missed: lastSequenceNumber=" + lastSequenceNumber + " newSequenceNumber=" + newSequenceNumber);
            }
            if (AbstractMonitoringSupport.this.notificationListener != null) {
                AbstractMonitoringSupport.this.notificationListener.onMissingData(lastSequenceNumber.longValue(), sequenceNumber);
            }
            return newSequenceNumber;
        }

        public void onNotificationData(Subscription subscription, NotificationData notification) {
        }

        public void onStatusChange(Subscription subscription, StatusCode oldStatus, StatusCode newStatus, DiagnosticInfo diagnosticInfo) {
            if (AbstractMonitoringSupport.this.m_logger != null) {
                AbstractMonitoringSupport.this.m_logger.log((Level)AcsLogLevel.TRACE, String.valueOf(AbstractMonitoringSupport.this.getNodeIdRefsAsStr()) + " Subscription status changed: from  <" + oldStatus + "> to <" + newStatus + ">, diagnostic: " + diagnosticInfo);
            }
        }
    }
}

