/*
 * Decompiled with CFR 0.152.
 */
package cta.acs.opcua.da;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import cta.acs.opcua.da.UaClientPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class AbstractDataAccess
implements Closeable {
    protected final AcsLogger m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("OpcuaDataAccess", true);
    protected final String[] nodeIdRefs;
    private final String serverURI;
    private final NodeId[] nodeIds;
    private UaClient uaClient;

    public AbstractDataAccess(String serverURI, String ... nodeIdRefs) throws IllegalArgumentException {
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Started");
        if (serverURI == null) {
            throw new IllegalArgumentException("serverURI == null");
        }
        this.serverURI = serverURI;
        if (nodeIdRefs == null) {
            throw new IllegalArgumentException("nodeIdRefs == null");
        }
        int len = nodeIdRefs.length;
        if (len == 0) {
            throw new IllegalArgumentException("nodeIdRefs can no be empty.");
        }
        this.nodeIdRefs = nodeIdRefs;
        this.nodeIds = new NodeId[len];
        int i = 0;
        while (i < len) {
            this.nodeIds[i] = NodeId.parseNodeId((String)nodeIdRefs[i]);
            ++i;
        }
        try {
            UaClientPool.connect(serverURI);
            this.uaClient = UaClientPool.INSTANCE.getClient(serverURI);
        }
        catch (IOException e) {
            this.m_logger.log((Level)AcsLogLevel.ERROR, String.valueOf(this.getNodeIdRefsAsStr()) + " Connect to \"" + serverURI + "\" failed: " + e.getMessage());
        }
    }

    public AbstractDataAccess(UaClient uaClient, String ... nodeIdRefs) throws IllegalArgumentException {
        this.m_logger.log((Level)AcsLogLevel.DEBUG, "Started");
        if (nodeIdRefs == null) {
            throw new IllegalArgumentException("nodeIdRefs == null");
        }
        int len = nodeIdRefs.length;
        if (len == 0) {
            throw new IllegalArgumentException("nodeIdRefs can no be empty.");
        }
        this.nodeIdRefs = nodeIdRefs;
        if (uaClient == null) {
            throw new IllegalArgumentException("uaClient == null");
        }
        this.uaClient = uaClient;
        this.serverURI = this.uaClient.getAddress().getAddress();
        this.nodeIds = new NodeId[len];
        int i = 0;
        while (i < len) {
            this.nodeIds[i] = NodeId.parseNodeId((String)nodeIdRefs[i]);
            ++i;
        }
    }

    public AcsLogger getLogger() {
        return this.m_logger;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String[] getNodeIdRefs() {
        return this.nodeIdRefs;
    }

    public String getNodeIdRefsAsStr() {
        if (this.nodeIdRefs == null || this.nodeIdRefs.length == 0) {
            return "[]";
        }
        return Arrays.asList(this.nodeIdRefs).toString();
    }

    public String getNodeIdRef(int index) {
        return this.nodeIdRefs[index];
    }

    UaClient getUaClient() throws IOException {
        if (this.uaClient == null) {
            throw new IOException("uaClient == null!");
        }
        if (!this.uaClient.isConnected()) {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, String.valueOf(this.getNodeIdRefsAsStr()) + " Client is not connected. Trying to connect ...");
            UaClientPool.connect(this.serverURI);
            this.uaClient = UaClientPool.INSTANCE.getClient(this.serverURI);
        }
        return this.uaClient;
    }

    public int countNodes() {
        return this.nodeIdRefs.length;
    }

    public int getNodeIndex(String nodeIdRef) throws NullPointerException, IllegalArgumentException {
        if (nodeIdRef == null) {
            throw new NullPointerException("nodeIdRef == null");
        }
        int index = 0;
        while (index < this.nodeIdRefs.length) {
            if (nodeIdRef.equals(this.nodeIdRefs[index])) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("invalid nodeIdRef:" + nodeIdRef);
    }

    NodeId[] getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public void close() throws IOException {
        this.m_logger.log((Level)AcsLogLevel.TRACE, String.valueOf(this.getNodeIdRefsAsStr()) + " Closing data access ...");
        UaClientPool.disconnect(this.serverURI);
    }
}

