/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.FieldTargetDataType;
import com.prosysopc.ua.types.opcua.TargetVariablesType;
import com.prosysopc.ua.types.opcua.server.SubscribedDataSetTypeNode;
import com.prosysopc.ua.types.opcua.server.TargetVariablesTypeAddTargetVariablesMethod;
import com.prosysopc.ua.types.opcua.server.TargetVariablesTypeNode;
import com.prosysopc.ua.types.opcua.server.TargetVariablesTypeRemoveTargetVariablesMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15111")
public abstract class TargetVariablesTypeNodeBase
extends SubscribedDataSetTypeNode
implements TargetVariablesType {
    private static GeneratedNodeInitializer<TargetVariablesTypeNode> HT;
    private static TargetVariablesTypeRemoveTargetVariablesMethod HU;
    private static TargetVariablesTypeAddTargetVariablesMethod HV;

    protected TargetVariablesTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TargetVariablesTypeNode> generatedNodeInitializer = TargetVariablesTypeNodeBase.getTargetVariablesTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TargetVariablesTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TargetVariablesTypeNode> getTargetVariablesTypeNodeInitializer() {
        return HT;
    }

    public static void setTargetVariablesTypeNodeInitializer(GeneratedNodeInitializer<TargetVariablesTypeNode> generatedNodeInitializer) {
        HT = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TargetVariables");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public FieldTargetDataType[] getTargetVariables() {
        UaProperty uaProperty = this.getTargetVariablesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TargetVariables does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (FieldTargetDataType[])object;
    }

    @Override
    @Mandatory
    public void setTargetVariables(FieldTargetDataType[] fieldTargetDataTypeArray) {
        UaProperty uaProperty = this.getTargetVariablesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TargetVariables failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(fieldTargetDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TargetVariables failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveTargetVariables"), nodeId)) {
            return new Variant[]{new Variant(this.b(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (UnsignedInteger[])variantArray[1].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddTargetVariables"), nodeId)) {
            return new Variant[]{new Variant(this.b(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (FieldTargetDataType[])variantArray[1].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract StatusCode[] onRemoveTargetVariables(ServiceContext var1, ConfigurationVersionDataType var2, UnsignedInteger[] var3) throws StatusException;

    @Override
    public StatusCode[] removeTargetVariables(ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) throws StatusException {
        return this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, unsignedIntegerArray);
    }

    private StatusCode[] b(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) throws StatusException {
        TargetVariablesTypeRemoveTargetVariablesMethod targetVariablesTypeRemoveTargetVariablesMethod = TargetVariablesTypeNodeBase.getRemoveTargetVariablesMethodImplementation();
        if (targetVariablesTypeRemoveTargetVariablesMethod != null) {
            return targetVariablesTypeRemoveTargetVariablesMethod.removeTargetVariables(serviceContext, (TargetVariablesTypeNode)this, configurationVersionDataType, unsignedIntegerArray);
        }
        return this.onRemoveTargetVariables(serviceContext, configurationVersionDataType, unsignedIntegerArray);
    }

    public static TargetVariablesTypeRemoveTargetVariablesMethod getRemoveTargetVariablesMethodImplementation() {
        return HU;
    }

    public static void setRemoveTargetVariablesMethodImplementation(TargetVariablesTypeRemoveTargetVariablesMethod targetVariablesTypeRemoveTargetVariablesMethod) {
        HU = targetVariablesTypeRemoveTargetVariablesMethod;
    }

    @Override
    @Optional
    public UaMethod getAddTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract StatusCode[] onAddTargetVariables(ServiceContext var1, ConfigurationVersionDataType var2, FieldTargetDataType[] var3) throws StatusException;

    @Override
    public StatusCode[] addTargetVariables(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws StatusException {
        return this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    private StatusCode[] b(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws StatusException {
        TargetVariablesTypeAddTargetVariablesMethod targetVariablesTypeAddTargetVariablesMethod = TargetVariablesTypeNodeBase.getAddTargetVariablesMethodImplementation();
        if (targetVariablesTypeAddTargetVariablesMethod != null) {
            return targetVariablesTypeAddTargetVariablesMethod.addTargetVariables(serviceContext, (TargetVariablesTypeNode)this, configurationVersionDataType, fieldTargetDataTypeArray);
        }
        return this.onAddTargetVariables(serviceContext, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    public static TargetVariablesTypeAddTargetVariablesMethod getAddTargetVariablesMethodImplementation() {
        return HV;
    }

    public static void setAddTargetVariablesMethodImplementation(TargetVariablesTypeAddTargetVariablesMethod targetVariablesTypeAddTargetVariablesMethod) {
        HV = targetVariablesTypeAddTargetVariablesMethod;
    }
}

