/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeOneShotShelveMethod;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeTimedShelveMethod;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeUnshelveMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2929")
public abstract class ShelvedStateMachineTypeNodeBase
extends FiniteStateMachineTypeNode
implements ShelvedStateMachineType {
    private static GeneratedNodeInitializer<ShelvedStateMachineTypeNode> HA;
    private static ShelvedStateMachineTypeOneShotShelveMethod HB;
    private static ShelvedStateMachineTypeTimedShelveMethod HC;
    private static ShelvedStateMachineTypeUnshelveMethod HF;

    protected ShelvedStateMachineTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ShelvedStateMachineTypeNode> generatedNodeInitializer = ShelvedStateMachineTypeNodeBase.getShelvedStateMachineTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ShelvedStateMachineTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ShelvedStateMachineTypeNode> getShelvedStateMachineTypeNodeInitializer() {
        return HA;
    }

    public static void setShelvedStateMachineTypeNodeInitializer(GeneratedNodeInitializer<ShelvedStateMachineTypeNode> generatedNodeInitializer) {
        HA = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getUnshelveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnshelveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUnshelveTime() {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UnshelveTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUnshelveTime(Double d2) {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnshelveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnshelveTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve"), nodeId)) {
            this.r(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve"), nodeId)) {
            this.a(serviceContext, (Double)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve"), nodeId)) {
            this.s(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getOneShotShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onOneShotShelve(ServiceContext var1) throws StatusException;

    @Override
    public void oneShotShelve() throws StatusException {
        this.r(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void r(ServiceContext serviceContext) throws StatusException {
        ShelvedStateMachineTypeOneShotShelveMethod shelvedStateMachineTypeOneShotShelveMethod = ShelvedStateMachineTypeNodeBase.getOneShotShelveMethodImplementation();
        if (shelvedStateMachineTypeOneShotShelveMethod != null) {
            shelvedStateMachineTypeOneShotShelveMethod.oneShotShelve(serviceContext, (ShelvedStateMachineTypeNode)this);
        } else {
            this.onOneShotShelve(serviceContext);
        }
    }

    public static ShelvedStateMachineTypeOneShotShelveMethod getOneShotShelveMethodImplementation() {
        return HB;
    }

    public static void setOneShotShelveMethodImplementation(ShelvedStateMachineTypeOneShotShelveMethod shelvedStateMachineTypeOneShotShelveMethod) {
        HB = shelvedStateMachineTypeOneShotShelveMethod;
    }

    @Override
    @Mandatory
    public UaMethod getTimedShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onTimedShelve(ServiceContext var1, Double var2) throws StatusException;

    @Override
    public void timedShelve(Double d2) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, d2);
    }

    private void a(ServiceContext serviceContext, Double d2) throws StatusException {
        ShelvedStateMachineTypeTimedShelveMethod shelvedStateMachineTypeTimedShelveMethod = ShelvedStateMachineTypeNodeBase.getTimedShelveMethodImplementation();
        if (shelvedStateMachineTypeTimedShelveMethod != null) {
            shelvedStateMachineTypeTimedShelveMethod.timedShelve(serviceContext, (ShelvedStateMachineTypeNode)this, d2);
        } else {
            this.onTimedShelve(serviceContext, d2);
        }
    }

    public static ShelvedStateMachineTypeTimedShelveMethod getTimedShelveMethodImplementation() {
        return HC;
    }

    public static void setTimedShelveMethodImplementation(ShelvedStateMachineTypeTimedShelveMethod shelvedStateMachineTypeTimedShelveMethod) {
        HC = shelvedStateMachineTypeTimedShelveMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUnshelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnshelve(ServiceContext var1) throws StatusException;

    @Override
    public void unshelve() throws StatusException {
        this.s(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void s(ServiceContext serviceContext) throws StatusException {
        ShelvedStateMachineTypeUnshelveMethod shelvedStateMachineTypeUnshelveMethod = ShelvedStateMachineTypeNodeBase.getUnshelveMethodImplementation();
        if (shelvedStateMachineTypeUnshelveMethod != null) {
            shelvedStateMachineTypeUnshelveMethod.unshelve(serviceContext, (ShelvedStateMachineTypeNode)this);
        } else {
            this.onUnshelve(serviceContext);
        }
    }

    public static ShelvedStateMachineTypeUnshelveMethod getUnshelveMethodImplementation() {
        return HF;
    }

    public static void setUnshelveMethodImplementation(ShelvedStateMachineTypeUnshelveMethod shelvedStateMachineTypeUnshelveMethod) {
        HF = shelvedStateMachineTypeUnshelveMethod;
    }
}

