/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNodeBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2013")
public class ServerCapabilitiesTypeNode
extends ServerCapabilitiesTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(ServerCapabilitiesTypeNode.class);

    protected ServerCapabilitiesTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        Object object;
        Object object2;
        super.afterCreate();
        try {
            object2 = this.getNodeManager().getNodeManagerTable().getType(Identifiers.ModellingRuleType);
            for (UaReference uaReference : object = object2.getReferences(Identifiers.HasTypeDefinition, true)) {
                UaNode uaNode = uaReference.getSourceNode();
                this.getModellingRulesNode().addReference(uaNode, Identifiers.Organizes, false);
            }
        }
        catch (Exception exception) {
            logger.warn("Could not initialize references to ModellingRules", (Throwable)exception);
        }
        this.setServerProfileArray(this.egn());
        this.setLocaleIdArray(new String[]{LocalizedText.NO_LOCALE.getLanguage()});
        this.setMinSupportedSampleRate(0.0);
        this.setMaxBrowseContinuationPoints(UnsignedShort.ZERO);
        this.setMaxQueryContinuationPoints(UnsignedShort.ZERO);
        this.setMaxHistoryContinuationPoints(UnsignedShort.ZERO);
        object2 = this.getSoftwareCertificatesNode().getValue();
        object = DateTime.currentTime();
        ((DataValue)object2).setServerTimestamp((DateTime)object);
        ((DataValue)object2).setSourceTimestamp((DateTime)object);
        this.getOperationLimitsNode().afterCreate();
    }

    public void setFieldsFromEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        if (endpointConfiguration.getMaxArrayLength() != null) {
            this.setMaxArrayLength(UnsignedInteger.valueOf(endpointConfiguration.getMaxArrayLength().intValue()));
        }
        if (endpointConfiguration.getMaxStringLength() != null) {
            this.setMaxStringLength(UnsignedInteger.valueOf(endpointConfiguration.getMaxStringLength().intValue()));
        }
    }

    private String[] egn() {
        return new String[]{"Standard UA Server Profile", "Embedded UA Server Profile", "Micro Embedded Device Server Profile", "Nano Embedded Device Server Profile"};
    }
}

