/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.types.opcua.PublishedDataSetType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ExtensionFieldsTypeNode;
import com.prosysopc.ua.types.opcua.server.PublishedDataSetTypeNode;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14509")
public abstract class PublishedDataSetTypeNodeBase
extends BaseObjectTypeNode
implements PublishedDataSetType {
    private static GeneratedNodeInitializer<PublishedDataSetTypeNode> Gq;

    protected PublishedDataSetTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getExtensionFieldsNode());
        GeneratedNodeInitializer<PublishedDataSetTypeNode> generatedNodeInitializer = PublishedDataSetTypeNodeBase.getPublishedDataSetTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PublishedDataSetTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PublishedDataSetTypeNode> getPublishedDataSetTypeNodeInitializer() {
        return Gq;
    }

    public static void setPublishedDataSetTypeNodeInitializer(GeneratedNodeInitializer<PublishedDataSetTypeNode> generatedNodeInitializer) {
        Gq = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getConfigurationVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfigurationVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ConfigurationVersionDataType getConfigurationVersion() {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConfigurationVersion does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ConfigurationVersionDataType)object;
    }

    @Override
    @Mandatory
    public void setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConfigurationVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(configurationVersionDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfigurationVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDataSetClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UUID getDataSetClassId() {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UUID)object;
    }

    @Override
    @Optional
    public void setDataSetClassId(UUID uUID) {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uUID);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMetaData does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetMetaDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMetaData failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public ExtensionFieldsTypeNode getExtensionFieldsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExtensionFields");
        return (ExtensionFieldsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

