/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ProgramTransitionAuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditUpdateStateEventTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramTransitionAuditEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3806")
public abstract class ProgramTransitionAuditEventTypeNodeBase
extends AuditUpdateStateEventTypeNode
implements ProgramTransitionAuditEventType {
    private static GeneratedNodeInitializer<ProgramTransitionAuditEventTypeNode> FJ;

    protected ProgramTransitionAuditEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTransitionNode());
        GeneratedNodeInitializer<ProgramTransitionAuditEventTypeNode> generatedNodeInitializer = ProgramTransitionAuditEventTypeNodeBase.getProgramTransitionAuditEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ProgramTransitionAuditEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ProgramTransitionAuditEventTypeNode> getProgramTransitionAuditEventTypeNodeInitializer() {
        return FJ;
    }

    public static void setProgramTransitionAuditEventTypeNodeInitializer(GeneratedNodeInitializer<ProgramTransitionAuditEventTypeNode> generatedNodeInitializer) {
        FJ = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableTypeNode getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Transition does not exist");
        }
        Object object = finiteTransitionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting Transition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Transition failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

