/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.NDimensionArrayItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.NDimensionArrayItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12068")
public abstract class NDimensionArrayItemTypeNodeBase
extends ArrayItemTypeNode
implements NDimensionArrayItemType {
    private static GeneratedNodeInitializer<NDimensionArrayItemTypeNode> Fk;

    protected NDimensionArrayItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<NDimensionArrayItemTypeNode> generatedNodeInitializer = NDimensionArrayItemTypeNodeBase.getNDimensionArrayItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NDimensionArrayItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NDimensionArrayItemTypeNode> getNDimensionArrayItemTypeNodeInitializer() {
        return Fk;
    }

    public static void setNDimensionArrayItemTypeNodeInitializer(GeneratedNodeInitializer<NDimensionArrayItemTypeNode> generatedNodeInitializer) {
        Fk = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation[] getAxisDefinition() {
        UaProperty uaProperty = this.getAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation[])object;
    }

    @Override
    @Mandatory
    public void setAxisDefinition(AxisInformation[] axisInformationArray) {
        UaProperty uaProperty = this.getAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformationArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AxisDefinition failed unexpectedly", statusException);
        }
    }
}

