/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.NamingRuleType;
import com.prosysopc.ua.types.opcua.ModellingRuleType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ModellingRuleTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=77")
public abstract class ModellingRuleTypeNodeBase
extends BaseObjectTypeNode
implements ModellingRuleType {
    private static GeneratedNodeInitializer<ModellingRuleTypeNode> Ff;

    protected ModellingRuleTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ModellingRuleTypeNode> generatedNodeInitializer = ModellingRuleTypeNodeBase.getModellingRuleTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ModellingRuleTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ModellingRuleTypeNode> getModellingRuleTypeNodeInitializer() {
        return Ff;
    }

    public static void setModellingRuleTypeNodeInitializer(GeneratedNodeInitializer<ModellingRuleTypeNode> generatedNodeInitializer) {
        Ff = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNamingRuleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamingRule");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NamingRuleType getNamingRule() {
        UaProperty uaProperty = this.getNamingRuleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NamingRule does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (NamingRuleType)variant.asEnum(NamingRuleType.class);
    }

    @Override
    @Mandatory
    public void setNamingRule(NamingRuleType namingRuleType) {
        UaProperty uaProperty = this.getNamingRuleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamingRule failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(namingRuleType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamingRule failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

