/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.LimitAlarmType;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2955")
public abstract class LimitAlarmTypeNodeBase
extends AlarmConditionTypeNode
implements LimitAlarmType {
    private static GeneratedNodeInitializer<LimitAlarmTypeNode> Fd;

    protected LimitAlarmTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<LimitAlarmTypeNode> generatedNodeInitializer = LimitAlarmTypeNodeBase.getLimitAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LimitAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LimitAlarmTypeNode> getLimitAlarmTypeNodeInitializer() {
        return Fd;
    }

    public static void setLimitAlarmTypeNodeInitializer(GeneratedNodeInitializer<LimitAlarmTypeNode> generatedNodeInitializer) {
        Fd = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getLowLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getLowLowLimit() {
        UaProperty uaProperty = this.getLowLowLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setLowLowLimit(Double d2) {
        UaProperty uaProperty = this.getLowLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LowLowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLowLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBaseHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseHighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getBaseHighLimit() {
        UaProperty uaProperty = this.getBaseHighLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setBaseHighLimit(Double d2) {
        UaProperty uaProperty = this.getBaseHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseHighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseHighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBaseLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseLowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getBaseLowLimit() {
        UaProperty uaProperty = this.getBaseLowLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setBaseLowLimit(Double d2) {
        UaProperty uaProperty = this.getBaseLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseLowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseLowLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBaseHighHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseHighHighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getBaseHighHighLimit() {
        UaProperty uaProperty = this.getBaseHighHighLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setBaseHighHighLimit(Double d2) {
        UaProperty uaProperty = this.getBaseHighHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseHighHighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseHighHighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getHighHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighHighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getHighHighLimit() {
        UaProperty uaProperty = this.getHighHighLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setHighHighLimit(Double d2) {
        UaProperty uaProperty = this.getHighHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighHighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighHighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBaseLowLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseLowLowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getBaseLowLowLimit() {
        UaProperty uaProperty = this.getBaseLowLowLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setBaseLowLowLimit(Double d2) {
        UaProperty uaProperty = this.getBaseLowLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseLowLowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseLowLowLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getHighLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getHighLimit() {
        UaProperty uaProperty = this.getHighLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setHighLimit(Double d2) {
        UaProperty uaProperty = this.getHighLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getLowLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getLowLimit() {
        UaProperty uaProperty = this.getLowLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setLowLimit(Double d2) {
        UaProperty uaProperty = this.getLowLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LowLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LowLimit failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

