/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.KeyCredentialConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.KeyCredentialConfigurationTypeDeleteCredentialMethod;
import com.prosysopc.ua.types.opcua.server.KeyCredentialConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.KeyCredentialConfigurationTypeUpdateCredentialMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18001")
public abstract class KeyCredentialConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements KeyCredentialConfigurationType {
    private static GeneratedNodeInitializer<KeyCredentialConfigurationTypeNode> EY;
    private static KeyCredentialConfigurationTypeDeleteCredentialMethod EZ;
    private static KeyCredentialConfigurationTypeUpdateCredentialMethod Fa;

    protected KeyCredentialConfigurationTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<KeyCredentialConfigurationTypeNode> generatedNodeInitializer = KeyCredentialConfigurationTypeNodeBase.getKeyCredentialConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((KeyCredentialConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<KeyCredentialConfigurationTypeNode> getKeyCredentialConfigurationTypeNodeInitializer() {
        return EY;
    }

    public static void setKeyCredentialConfigurationTypeNodeInitializer(GeneratedNodeInitializer<KeyCredentialConfigurationTypeNode> generatedNodeInitializer) {
        EY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResourceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResourceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProfileUri() {
        UaProperty uaProperty = this.getProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ProfileUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProfileUri(String string) {
        UaProperty uaProperty = this.getProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProfileUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProfileUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getServiceStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceStatus");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public StatusCode getServiceStatus() {
        UaProperty uaProperty = this.getServiceStatusNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Optional
    public void setServiceStatus(StatusCode statusCode) {
        UaProperty uaProperty = this.getServiceStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(statusCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceStatus failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEndpointUrlsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrls");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String[] getEndpointUrls() {
        UaProperty uaProperty = this.getEndpointUrlsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Optional
    public void setEndpointUrls(String[] stringArray) {
        UaProperty uaProperty = this.getEndpointUrlsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrls failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrls failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteCredential"), nodeId)) {
            this.k(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCredential"), nodeId)) {
            this.a(serviceContext, (String)variantArray[0].getValue(), (ByteString)variantArray[1].getValue(), (String)variantArray[2].getValue(), (String)variantArray[3].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getDeleteCredentialNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteCredential");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onDeleteCredential(ServiceContext var1) throws StatusException;

    @Override
    public void deleteCredential() throws StatusException {
        this.k(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void k(ServiceContext serviceContext) throws StatusException {
        KeyCredentialConfigurationTypeDeleteCredentialMethod keyCredentialConfigurationTypeDeleteCredentialMethod = KeyCredentialConfigurationTypeNodeBase.getDeleteCredentialMethodImplementation();
        if (keyCredentialConfigurationTypeDeleteCredentialMethod != null) {
            keyCredentialConfigurationTypeDeleteCredentialMethod.deleteCredential(serviceContext, (KeyCredentialConfigurationTypeNode)this);
        } else {
            this.onDeleteCredential(serviceContext);
        }
    }

    public static KeyCredentialConfigurationTypeDeleteCredentialMethod getDeleteCredentialMethodImplementation() {
        return EZ;
    }

    public static void setDeleteCredentialMethodImplementation(KeyCredentialConfigurationTypeDeleteCredentialMethod keyCredentialConfigurationTypeDeleteCredentialMethod) {
        EZ = keyCredentialConfigurationTypeDeleteCredentialMethod;
    }

    @Override
    @Optional
    public UaMethod getUpdateCredentialNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCredential");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUpdateCredential(ServiceContext var1, String var2, ByteString var3, String var4, String var5) throws StatusException;

    @Override
    public void updateCredential(String string, ByteString byteString, String string2, String string3) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, byteString, string2, string3);
    }

    private void a(ServiceContext serviceContext, String string, ByteString byteString, String string2, String string3) throws StatusException {
        KeyCredentialConfigurationTypeUpdateCredentialMethod keyCredentialConfigurationTypeUpdateCredentialMethod = KeyCredentialConfigurationTypeNodeBase.getUpdateCredentialMethodImplementation();
        if (keyCredentialConfigurationTypeUpdateCredentialMethod != null) {
            keyCredentialConfigurationTypeUpdateCredentialMethod.updateCredential(serviceContext, (KeyCredentialConfigurationTypeNode)this, string, byteString, string2, string3);
        } else {
            this.onUpdateCredential(serviceContext, string, byteString, string2, string3);
        }
    }

    public static KeyCredentialConfigurationTypeUpdateCredentialMethod getUpdateCredentialMethodImplementation() {
        return Fa;
    }

    public static void setUpdateCredentialMethodImplementation(KeyCredentialConfigurationTypeUpdateCredentialMethod keyCredentialConfigurationTypeUpdateCredentialMethod) {
        Fa = keyCredentialConfigurationTypeUpdateCredentialMethod;
    }
}

