/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.IOrderedObjectType;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IOrderedObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23513")
public abstract class IOrderedObjectTypeNodeBase
extends BaseInterfaceTypeNode
implements IOrderedObjectType {
    private static GeneratedNodeInitializer<IOrderedObjectTypeNode> EN;

    protected IOrderedObjectTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<IOrderedObjectTypeNode> generatedNodeInitializer = IOrderedObjectTypeNodeBase.getIOrderedObjectTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IOrderedObjectTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IOrderedObjectTypeNode> getIOrderedObjectTypeNodeInitializer() {
        return EN;
    }

    public static void setIOrderedObjectTypeNodeInitializer(GeneratedNodeInitializer<IOrderedObjectTypeNode> generatedNodeInitializer) {
        EN = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNumberInListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NumberInList");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getNumberInList() {
        UaProperty uaProperty = this.getNumberInListNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NumberInList does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setNumberInList(Object object) {
        UaProperty uaProperty = this.getNumberInListNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NumberInList failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NumberInList failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

