/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.DialogConditionType;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.DialogConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.DialogConditionTypeRespondMethod;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2830")
public abstract class DialogConditionTypeNodeBase
extends ConditionTypeNode
implements DialogConditionType {
    private static GeneratedNodeInitializer<DialogConditionTypeNode> DP;
    private static DialogConditionTypeRespondMethod DQ;

    protected DialogConditionTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getDialogStateNode());
        GeneratedNodeInitializer<DialogConditionTypeNode> generatedNodeInitializer = DialogConditionTypeNodeBase.getDialogConditionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DialogConditionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DialogConditionTypeNode> getDialogConditionTypeNodeInitializer() {
        return DP;
    }

    public static void setDialogConditionTypeNodeInitializer(GeneratedNodeInitializer<DialogConditionTypeNode> generatedNodeInitializer) {
        DP = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getDefaultResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getDefaultResponse() {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DefaultResponse does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setDefaultResponse(Integer n2) {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DefaultResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getOkResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OkResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getOkResponse() {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node OkResponse does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setOkResponse(Integer n2) {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OkResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OkResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCancelResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CancelResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getCancelResponse() {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CancelResponse does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setCancelResponse(Integer n2) {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CancelResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CancelResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getLastResponse() {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LastResponse does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setLastResponse(Integer n2) {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastResponse failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPromptNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Prompt");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getPrompt() {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Prompt does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setPrompt(LocalizedText localizedText) {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Prompt failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Prompt failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getResponseOptionSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResponseOptionSet");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getResponseOptionSet() {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResponseOptionSet does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setResponseOptionSet(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResponseOptionSet failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResponseOptionSet failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getDialogStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DialogState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getDialogState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getDialogStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DialogState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setDialogState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getDialogStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting DialogState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DialogState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Respond"), nodeId)) {
            this.a(serviceContext, (Integer)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getRespondNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Respond");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRespond(ServiceContext var1, Integer var2) throws StatusException;

    @Override
    public void respond(Integer n2) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, n2);
    }

    private void a(ServiceContext serviceContext, Integer n2) throws StatusException {
        DialogConditionTypeRespondMethod dialogConditionTypeRespondMethod = DialogConditionTypeNodeBase.getRespondMethodImplementation();
        if (dialogConditionTypeRespondMethod != null) {
            dialogConditionTypeRespondMethod.respond(serviceContext, (DialogConditionTypeNode)this, n2);
        } else {
            this.onRespond(serviceContext, n2);
        }
    }

    public static DialogConditionTypeRespondMethod getRespondMethodImplementation() {
        return DQ;
    }

    public static void setRespondMethodImplementation(DialogConditionTypeRespondMethod dialogConditionTypeRespondMethod) {
        DQ = dialogConditionTypeRespondMethod;
    }
}

