/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.DatagramWriterGroupTransportType;
import com.prosysopc.ua.types.opcua.server.DatagramWriterGroupTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupTransportTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21133")
public abstract class DatagramWriterGroupTransportTypeNodeBase
extends WriterGroupTransportTypeNode
implements DatagramWriterGroupTransportType {
    private static GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> DN;

    protected DatagramWriterGroupTransportTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> generatedNodeInitializer = DatagramWriterGroupTransportTypeNodeBase.getDatagramWriterGroupTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DatagramWriterGroupTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> getDatagramWriterGroupTransportTypeNodeInitializer() {
        return DN;
    }

    public static void setDatagramWriterGroupTransportTypeNodeInitializer(GeneratedNodeInitializer<DatagramWriterGroupTransportTypeNode> generatedNodeInitializer) {
        DN = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getMessageRepeatDelayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageRepeatDelay");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMessageRepeatDelay() {
        UaProperty uaProperty = this.getMessageRepeatDelayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMessageRepeatDelay(Double d2) {
        UaProperty uaProperty = this.getMessageRepeatDelayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageRepeatDelay failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MessageRepeatDelay failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMessageRepeatCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageRepeatCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte getMessageRepeatCount() {
        UaProperty uaProperty = this.getMessageRepeatCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Optional
    public void setMessageRepeatCount(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getMessageRepeatCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageRepeatCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MessageRepeatCount failed unexpectedly", statusException);
        }
    }

    public void setMessageRepeatCount(int n2) {
        this.setMessageRepeatCount(UnsignedByte.valueOf(n2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

