/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DataTypeDictionaryType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.DataTypeDictionaryTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=72")
public abstract class DataTypeDictionaryTypeNodeBase
extends BaseDataVariableTypeNode
implements DataTypeDictionaryType {
    private static GeneratedNodeInitializer<DataTypeDictionaryTypeNode> DJ;

    protected DataTypeDictionaryTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<DataTypeDictionaryTypeNode> generatedNodeInitializer = DataTypeDictionaryTypeNodeBase.getDataTypeDictionaryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DataTypeDictionaryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DataTypeDictionaryTypeNode> getDataTypeDictionaryTypeNodeInitializer() {
        return DJ;
    }

    public static void setDataTypeDictionaryTypeNodeInitializer(GeneratedNodeInitializer<DataTypeDictionaryTypeNode> generatedNodeInitializer) {
        DJ = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getDataTypeVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataTypeVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDataTypeVersion() {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDataTypeVersion(String string) {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataTypeVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataTypeVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDeprecatedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Deprecated");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isDeprecated() {
        UaProperty uaProperty = this.getDeprecatedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setDeprecated(Boolean bl) {
        UaProperty uaProperty = this.getDeprecatedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Deprecated failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Deprecated failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getNamespaceUri() {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setNamespaceUri(String string) {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceUri failed unexpectedly", statusException);
        }
    }
}

