/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.FieldTargetDataType;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.RolePermissionType;
import com.prosysopc.ua.types.opcua.DataSetReaderType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetReaderMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetReaderTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetReaderTypeCreateDataSetMirrorMethod;
import com.prosysopc.ua.types.opcua.server.DataSetReaderTypeCreateTargetVariablesMethod;
import com.prosysopc.ua.types.opcua.server.DataSetReaderTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsDataSetReaderTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscribedDataSetTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15306")
public abstract class DataSetReaderTypeNodeBase
extends BaseObjectTypeNode
implements DataSetReaderType {
    private static GeneratedNodeInitializer<DataSetReaderTypeNode> DB;
    private static DataSetReaderTypeCreateDataSetMirrorMethod DC;
    private static DataSetReaderTypeCreateTargetVariablesMethod DD;

    protected DataSetReaderTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSubscribedDataSetNode());
        this.callAfterCreateIfExists(this.getMessageSettingsNode());
        this.callAfterCreateIfExists(this.getStatusNode());
        this.callAfterCreateIfExists(this.getTransportSettingsNode());
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        GeneratedNodeInitializer<DataSetReaderTypeNode> generatedNodeInitializer = DataSetReaderTypeNodeBase.getDataSetReaderTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DataSetReaderTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DataSetReaderTypeNode> getDataSetReaderTypeNodeInitializer() {
        return DB;
    }

    public static void setDataSetReaderTypeNodeInitializer(GeneratedNodeInitializer<DataSetReaderTypeNode> generatedNodeInitializer) {
        DB = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getPublisherIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublisherId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getPublisherId() {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublisherId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setPublisherId(Object object) {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublisherId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublisherId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMetaData does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetMetaDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMetaData failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMessageReceiveTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageReceiveTimeout");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMessageReceiveTimeout() {
        UaProperty uaProperty = this.getMessageReceiveTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MessageReceiveTimeout does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMessageReceiveTimeout(Double d2) {
        UaProperty uaProperty = this.getMessageReceiveTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MessageReceiveTimeout failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MessageReceiveTimeout failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityKeyServicesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityKeyServices");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointDescription[] getSecurityKeyServices() {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointDescription[])object;
    }

    @Override
    @Optional
    public void setSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityKeyServices failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(endpointDescriptionArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityKeyServices failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getWriterGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "WriterGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getWriterGroupId() {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node WriterGroupId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setWriterGroupId(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting WriterGroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting WriterGroupId failed unexpectedly", statusException);
        }
    }

    public void setWriterGroupId(int n2) {
        this.setWriterGroupId(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getKeyFrameCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyFrameCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getKeyFrameCount() {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node KeyFrameCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setKeyFrameCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyFrameCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting KeyFrameCount failed unexpectedly", statusException);
        }
    }

    public void setKeyFrameCount(long l2) {
        this.setKeyFrameCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Optional
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(messageSecurityMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetReaderPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetReaderProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getDataSetReaderProperties() {
        UaProperty uaProperty = this.getDataSetReaderPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetReaderProperties does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setDataSetReaderProperties(KeyValuePair[] keyValuePairArray) {
        UaProperty uaProperty = this.getDataSetReaderPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetReaderProperties failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(keyValuePairArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetReaderProperties failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetFieldContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetFieldContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetFieldContentMask getDataSetFieldContentMask() {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetFieldContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetFieldContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetFieldContentMask(DataSetFieldContentMask dataSetFieldContentMask) {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetFieldContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetWriterId() {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetWriterId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterId(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetWriterId failed unexpectedly", statusException);
        }
    }

    public void setDataSetWriterId(int n2) {
        this.setDataSetWriterId(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getHeaderLayoutUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HeaderLayoutUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getHeaderLayoutUri() {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node HeaderLayoutUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setHeaderLayoutUri(String string) {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HeaderLayoutUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HeaderLayoutUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityGroupId(String string) {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityGroupId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscribedDataSetTypeNode getSubscribedDataSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscribedDataSet");
        return (SubscribedDataSetTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetReaderMessageTypeNode getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (DataSetReaderMessageTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubStatusTypeNode getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetReaderTransportTypeNode getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (DataSetReaderTransportTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsDataSetReaderTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsDataSetReaderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateDataSetMirror"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (String)variantArray[0].getValue(), (RolePermissionType[])variantArray[1].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateTargetVariables"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (FieldTargetDataType[])variantArray[1].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getCreateDataSetMirrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateDataSetMirror");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onCreateDataSetMirror(ServiceContext var1, String var2, RolePermissionType[] var3) throws StatusException;

    @Override
    public NodeId createDataSetMirror(String string, RolePermissionType[] rolePermissionTypeArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, rolePermissionTypeArray);
    }

    private NodeId a(ServiceContext serviceContext, String string, RolePermissionType[] rolePermissionTypeArray) throws StatusException {
        DataSetReaderTypeCreateDataSetMirrorMethod dataSetReaderTypeCreateDataSetMirrorMethod = DataSetReaderTypeNodeBase.getCreateDataSetMirrorMethodImplementation();
        if (dataSetReaderTypeCreateDataSetMirrorMethod != null) {
            return dataSetReaderTypeCreateDataSetMirrorMethod.createDataSetMirror(serviceContext, (DataSetReaderTypeNode)this, string, rolePermissionTypeArray);
        }
        return this.onCreateDataSetMirror(serviceContext, string, rolePermissionTypeArray);
    }

    public static DataSetReaderTypeCreateDataSetMirrorMethod getCreateDataSetMirrorMethodImplementation() {
        return DC;
    }

    public static void setCreateDataSetMirrorMethodImplementation(DataSetReaderTypeCreateDataSetMirrorMethod dataSetReaderTypeCreateDataSetMirrorMethod) {
        DC = dataSetReaderTypeCreateDataSetMirrorMethod;
    }

    @Override
    @Optional
    public UaMethod getCreateTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract StatusCode[] onCreateTargetVariables(ServiceContext var1, ConfigurationVersionDataType var2, FieldTargetDataType[] var3) throws StatusException;

    @Override
    public StatusCode[] createTargetVariables(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    private StatusCode[] a(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws StatusException {
        DataSetReaderTypeCreateTargetVariablesMethod dataSetReaderTypeCreateTargetVariablesMethod = DataSetReaderTypeNodeBase.getCreateTargetVariablesMethodImplementation();
        if (dataSetReaderTypeCreateTargetVariablesMethod != null) {
            return dataSetReaderTypeCreateTargetVariablesMethod.createTargetVariables(serviceContext, (DataSetReaderTypeNode)this, configurationVersionDataType, fieldTargetDataTypeArray);
        }
        return this.onCreateTargetVariables(serviceContext, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    public static DataSetReaderTypeCreateTargetVariablesMethod getCreateTargetVariablesMethodImplementation() {
        return DD;
    }

    public static void setCreateTargetVariablesMethodImplementation(DataSetReaderTypeCreateTargetVariablesMethod dataSetReaderTypeCreateTargetVariablesMethod) {
        DD = dataSetReaderTypeCreateTargetVariablesMethod;
    }
}

