/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeAddCommentMethod;
import com.prosysopc.ua.types.opcua.server.ConditionTypeDisableMethod;
import com.prosysopc.ua.types.opcua.server.ConditionTypeEnableMethod;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2782")
public abstract class ConditionTypeNodeBase
extends BaseEventTypeNode
implements ConditionType {
    private static GeneratedNodeInitializer<ConditionTypeNode> Dh;
    private static ConditionTypeAddCommentMethod Di;
    private static ConditionTypeEnableMethod Dj;
    private static ConditionTypeDisableMethod Dk;

    protected ConditionTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCommentNode());
        this.callAfterCreateIfExists(this.getQualityNode());
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getLastSeverityNode());
        GeneratedNodeInitializer<ConditionTypeNode> generatedNodeInitializer = ConditionTypeNodeBase.getConditionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ConditionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ConditionTypeNode> getConditionTypeNodeInitializer() {
        return Dh;
    }

    public static void setConditionTypeNodeInitializer(GeneratedNodeInitializer<ConditionTypeNode> generatedNodeInitializer) {
        Dh = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getConditionSubClassName() {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassName(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionSubClassName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getBranchIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BranchId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getBranchId() {
        UaProperty uaProperty = this.getBranchIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node BranchId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setBranchId(NodeId nodeId) {
        UaProperty uaProperty = this.getBranchIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BranchId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BranchId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getConditionClassName() {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConditionClassName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setConditionClassName(LocalizedText localizedText) {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientUserId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getConditionSubClassId() {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassId(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionSubClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getConditionName() {
        UaProperty uaProperty = this.getConditionNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConditionName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setConditionName(String string) {
        UaProperty uaProperty = this.getConditionNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRetainNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Retain");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isRetain() {
        UaProperty uaProperty = this.getRetainNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Retain does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setRetain(Boolean bl) {
        UaProperty uaProperty = this.getRetainNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Retain failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Retain failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getConditionClassId() {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConditionClassId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setConditionClassId(NodeId nodeId) {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Comment");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getComment() {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getCommentNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Comment does not exist");
        }
        Object object = conditionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setComment(LocalizedText localizedText) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getCommentNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting Comment failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Comment failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getQualityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Quality");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getQuality() {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getQualityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Quality does not exist");
        }
        Object object = conditionVariableTypeNode.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setQuality(StatusCode statusCode) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getQualityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting Quality failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(statusCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Quality failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getLastSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastSeverity");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getLastSeverity() {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getLastSeverityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node LastSeverity does not exist");
        }
        Object object = conditionVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setLastSeverity(UnsignedShort unsignedShort) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getLastSeverityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastSeverity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastSeverity failed unexpectedly", statusException);
        }
    }

    public void setLastSeverity(int n2) {
        this.setLastSeverity(UnsignedShort.valueOf(n2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddComment"), nodeId)) {
            this.c(serviceContext, (ByteString)variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Enable"), nodeId)) {
            this.i(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Disable"), nodeId)) {
            this.j(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getAddCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddComment");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddComment(ServiceContext var1, ByteString var2, LocalizedText var3) throws StatusException;

    @Override
    public void addComment(ByteString byteString, LocalizedText localizedText) throws StatusException {
        this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT, byteString, localizedText);
    }

    private void c(ServiceContext serviceContext, ByteString byteString, LocalizedText localizedText) throws StatusException {
        ConditionTypeAddCommentMethod conditionTypeAddCommentMethod = ConditionTypeNodeBase.getAddCommentMethodImplementation();
        if (conditionTypeAddCommentMethod != null) {
            conditionTypeAddCommentMethod.addComment(serviceContext, (ConditionTypeNode)this, byteString, localizedText);
        } else {
            this.onAddComment(serviceContext, byteString, localizedText);
        }
    }

    public static ConditionTypeAddCommentMethod getAddCommentMethodImplementation() {
        return Di;
    }

    public static void setAddCommentMethodImplementation(ConditionTypeAddCommentMethod conditionTypeAddCommentMethod) {
        Di = conditionTypeAddCommentMethod;
    }

    @Override
    @Mandatory
    public UaMethod getEnableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Enable");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onEnable(ServiceContext var1) throws StatusException;

    @Override
    public void enable() throws StatusException {
        this.i(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void i(ServiceContext serviceContext) throws StatusException {
        ConditionTypeEnableMethod conditionTypeEnableMethod = ConditionTypeNodeBase.getEnableMethodImplementation();
        if (conditionTypeEnableMethod != null) {
            conditionTypeEnableMethod.enable(serviceContext, (ConditionTypeNode)this);
        } else {
            this.onEnable(serviceContext);
        }
    }

    public static ConditionTypeEnableMethod getEnableMethodImplementation() {
        return Dj;
    }

    public static void setEnableMethodImplementation(ConditionTypeEnableMethod conditionTypeEnableMethod) {
        Dj = conditionTypeEnableMethod;
    }

    @Override
    @Mandatory
    public UaMethod getDisableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Disable");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onDisable(ServiceContext var1) throws StatusException;

    @Override
    public void disable() throws StatusException {
        this.j(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void j(ServiceContext serviceContext) throws StatusException {
        ConditionTypeDisableMethod conditionTypeDisableMethod = ConditionTypeNodeBase.getDisableMethodImplementation();
        if (conditionTypeDisableMethod != null) {
            conditionTypeDisableMethod.disable(serviceContext, (ConditionTypeNode)this);
        } else {
            this.onDisable(serviceContext);
        }
    }

    public static ConditionTypeDisableMethod getDisableMethodImplementation() {
        return Dk;
    }

    public static void setDisableMethodImplementation(ConditionTypeDisableMethod conditionTypeDisableMethod) {
        Dk = conditionTypeDisableMethod;
    }
}

