/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.CertificateGroupType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateExpirationAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListOutOfDateAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12555")
public abstract class CertificateGroupTypeNodeBase
extends BaseObjectTypeNode
implements CertificateGroupType {
    private static GeneratedNodeInitializer<CertificateGroupTypeNode> Dd;

    protected CertificateGroupTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTrustListNode());
        this.callAfterCreateIfExists(this.getCertificateExpiredNode());
        this.callAfterCreateIfExists(this.getTrustListOutOfDateNode());
        GeneratedNodeInitializer<CertificateGroupTypeNode> generatedNodeInitializer = CertificateGroupTypeNodeBase.getCertificateGroupTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CertificateGroupTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CertificateGroupTypeNode> getCertificateGroupTypeNodeInitializer() {
        return Dd;
    }

    public static void setCertificateGroupTypeNodeInitializer(GeneratedNodeInitializer<CertificateGroupTypeNode> generatedNodeInitializer) {
        Dd = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getCertificateTypes() {
        UaProperty uaProperty = this.getCertificateTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CertificateTypes does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setCertificateTypes(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getCertificateTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateTypes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CertificateTypes failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TrustListTypeNode getTrustListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustList");
        return (TrustListTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public CertificateExpirationAlarmTypeNode getCertificateExpiredNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateExpired");
        return (CertificateExpirationAlarmTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public TrustListOutOfDateAlarmTypeNode getTrustListOutOfDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustListOutOfDate");
        return (TrustListOutOfDateAlarmTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

