/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditConditionShelvingEventType;
import com.prosysopc.ua.types.opcua.server.AuditConditionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditConditionShelvingEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11093")
public abstract class AuditConditionShelvingEventTypeNodeBase
extends AuditConditionEventTypeNode
implements AuditConditionShelvingEventType {
    private static GeneratedNodeInitializer<AuditConditionShelvingEventTypeNode> Cl;

    protected AuditConditionShelvingEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditConditionShelvingEventTypeNode> generatedNodeInitializer = AuditConditionShelvingEventTypeNodeBase.getAuditConditionShelvingEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditConditionShelvingEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditConditionShelvingEventTypeNode> getAuditConditionShelvingEventTypeNodeInitializer() {
        return Cl;
    }

    public static void setAuditConditionShelvingEventTypeNodeInitializer(GeneratedNodeInitializer<AuditConditionShelvingEventTypeNode> generatedNodeInitializer) {
        Cl = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getShelvingTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShelvingTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getShelvingTime() {
        UaProperty uaProperty = this.getShelvingTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setShelvingTime(Double d2) {
        UaProperty uaProperty = this.getShelvingTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ShelvingTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ShelvingTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

