/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditCancelEventType;
import com.prosysopc.ua.types.opcua.server.AuditCancelEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditSessionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2078")
public abstract class AuditCancelEventTypeNodeBase
extends AuditSessionEventTypeNode
implements AuditCancelEventType {
    private static GeneratedNodeInitializer<AuditCancelEventTypeNode> BU;

    protected AuditCancelEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditCancelEventTypeNode> generatedNodeInitializer = AuditCancelEventTypeNodeBase.getAuditCancelEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditCancelEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditCancelEventTypeNode> getAuditCancelEventTypeNodeInitializer() {
        return BU;
    }

    public static void setAuditCancelEventTypeNodeInitializer(GeneratedNodeInitializer<AuditCancelEventTypeNode> generatedNodeInitializer) {
        BU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRequestHandleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestHandle");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRequestHandle() {
        UaProperty uaProperty = this.getRequestHandleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RequestHandle does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getRequestHandleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestHandle failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestHandle failed unexpectedly", statusException);
        }
    }

    public void setRequestHandle(long l2) {
        this.setRequestHandle(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

