/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.types.opcua.AuditAddNodesEventType;
import com.prosysopc.ua.types.opcua.server.AuditAddNodesEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditNodeManagementEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2091")
public abstract class AuditAddNodesEventTypeNodeBase
extends AuditNodeManagementEventTypeNode
implements AuditAddNodesEventType {
    private static GeneratedNodeInitializer<AuditAddNodesEventTypeNode> BS;

    protected AuditAddNodesEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditAddNodesEventTypeNode> generatedNodeInitializer = AuditAddNodesEventTypeNodeBase.getAuditAddNodesEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditAddNodesEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditAddNodesEventTypeNode> getAuditAddNodesEventTypeNodeInitializer() {
        return BS;
    }

    public static void setAuditAddNodesEventTypeNodeInitializer(GeneratedNodeInitializer<AuditAddNodesEventTypeNode> generatedNodeInitializer) {
        BS = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getNodesToAddNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NodesToAdd");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AddNodesItem[] getNodesToAdd() {
        UaProperty uaProperty = this.getNodesToAddNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NodesToAdd does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AddNodesItem[])object;
    }

    @Override
    @Mandatory
    public void setNodesToAdd(AddNodesItem[] addNodesItemArray) {
        UaProperty uaProperty = this.getNodesToAddNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NodesToAdd failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(addNodesItemArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NodesToAdd failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

