/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.TwoStateDiscreteType;
import com.prosysopc.ua.types.opcua.client.DiscreteItemTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2373")
public abstract class TwoStateDiscreteTypeImplBase
extends DiscreteItemTypeImpl
implements TwoStateDiscreteType {
    protected TwoStateDiscreteTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getFalseStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FalseState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFalseState() {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFalseState(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getFalseStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting FalseState failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getTrueStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrueState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTrueState() {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTrueState(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getTrueStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrueState failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }
}

