/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.RedundantServerDataType;
import com.prosysopc.ua.types.opcua.TransparentRedundancyType;
import com.prosysopc.ua.types.opcua.client.ServerRedundancyTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2036")
public abstract class TransparentRedundancyTypeImplBase
extends ServerRedundancyTypeImpl
implements TransparentRedundancyType {
    protected TransparentRedundancyTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCurrentServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getCurrentServerId() {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setCurrentServerId(String string) throws StatusException {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CurrentServerId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerDataType[] getRedundantServerArray() {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Mandatory
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(redundantServerDataTypeArray);
    }
}

