/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import com.prosysopc.ua.types.opcua.SemanticChangeEventType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2738")
public abstract class SemanticChangeEventTypeImplBase
extends BaseEventTypeImpl
implements SemanticChangeEventType {
    protected SemanticChangeEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Changes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SemanticChangeStructureDataType[] getChanges() {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SemanticChangeStructureDataType[])object;
    }

    @Override
    @Mandatory
    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Changes failed, the Optional node does not exist)");
        }
        uaProperty.setValue(semanticChangeStructureDataTypeArray);
    }
}

