/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.SelectionListType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=16309")
public abstract class SelectionListTypeImplBase
extends BaseDataVariableTypeImpl
implements SelectionListType {
    protected SelectionListTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getSelectionDescriptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SelectionDescriptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getSelectionDescriptions() {
        UaProperty uaProperty = this.getSelectionDescriptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setSelectionDescriptions(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getSelectionDescriptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SelectionDescriptions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Mandatory
    public UaProperty getSelectionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Selections");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object[] getSelections() {
        UaProperty uaProperty = this.getSelectionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Object[])object;
    }

    @Override
    @Mandatory
    public void setSelections(Object[] objectArray) throws StatusException {
        UaProperty uaProperty = this.getSelectionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Selections failed, the Optional node does not exist)");
        }
        uaProperty.setValue(objectArray);
    }

    @Override
    @Optional
    public UaProperty getRestrictToListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RestrictToList");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRestrictToList() {
        UaProperty uaProperty = this.getRestrictToListNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRestrictToList(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getRestrictToListNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RestrictToList failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }
}

