/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.SecurityGroupType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15471")
public abstract class SecurityGroupTypeImplBase
extends BaseObjectTypeImpl
implements SecurityGroupType {
    protected SecurityGroupTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getKeyLifetimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyLifetime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getKeyLifetime() {
        UaProperty uaProperty = this.getKeyLifetimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setKeyLifetime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getKeyLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyLifetime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getMaxPastKeyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxPastKeyCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxPastKeyCount() {
        UaProperty uaProperty = this.getMaxPastKeyCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxPastKeyCount(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxPastKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxPastKeyCount failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityGroupId(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getMaxFutureKeyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxFutureKeyCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxFutureKeyCount() {
        UaProperty uaProperty = this.getMaxFutureKeyCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxFutureKeyCount(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxFutureKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxFutureKeyCount failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }
}

