/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.RationalNumberType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17709")
public abstract class RationalNumberTypeImplBase
extends BaseDataVariableTypeImpl
implements RationalNumberType {
    protected RationalNumberTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getNumeratorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Numerator");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getNumerator() {
        BaseDataVariableType baseDataVariableType = this.getNumeratorNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setNumerator(Integer n2) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getNumeratorNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting Numerator failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(n2);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getDenominatorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Denominator");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDenominator() {
        BaseDataVariableType baseDataVariableType = this.getDenominatorNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDenominator(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getDenominatorNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting Denominator failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }
}

