/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.types.opcua.ExtensionFieldsType;
import com.prosysopc.ua.types.opcua.PublishedDataSetType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14509")
public abstract class PublishedDataSetTypeImplBase
extends BaseObjectTypeImpl
implements PublishedDataSetType {
    protected PublishedDataSetTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getConfigurationVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfigurationVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ConfigurationVersionDataType getConfigurationVersion() {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ConfigurationVersionDataType)object;
    }

    @Override
    @Mandatory
    public void setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) throws StatusException {
        UaProperty uaProperty = this.getConfigurationVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConfigurationVersion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(configurationVersionDataType);
    }

    @Override
    @Optional
    public UaProperty getDataSetClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UUID getDataSetClassId() {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UUID)object;
    }

    @Override
    @Optional
    public void setDataSetClassId(UUID uUID) throws StatusException {
        UaProperty uaProperty = this.getDataSetClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetClassId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(uUID);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) throws StatusException {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetMetaDataType);
    }

    @Override
    @Optional
    public ExtensionFieldsType getExtensionFieldsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExtensionFields");
        return (ExtensionFieldsType)this.getComponent(qualifiedName);
    }
}

