/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.types.opcua.PubSubCommunicationFailureEventType;
import com.prosysopc.ua.types.opcua.client.PubSubStatusEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15563")
public abstract class PubSubCommunicationFailureEventTypeImplBase
extends PubSubStatusEventTypeImpl
implements PubSubCommunicationFailureEventType {
    protected PubSubCommunicationFailureEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Error");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getError() {
        UaProperty uaProperty = this.getErrorNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setError(StatusCode statusCode) throws StatusException {
        UaProperty uaProperty = this.getErrorNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Error failed, the Optional node does not exist)");
        }
        uaProperty.setValue(statusCode);
    }
}

