/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.types.opcua.OrientationType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18779")
public abstract class OrientationTypeImplBase
extends BaseDataVariableTypeImpl
implements OrientationType {
    protected OrientationTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getAngleUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AngleUnit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getAngleUnit() {
        UaProperty uaProperty = this.getAngleUnitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setAngleUnit(EUInformation eUInformation) throws StatusException {
        UaProperty uaProperty = this.getAngleUnitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AngleUnit failed, the Optional node does not exist)");
        }
        uaProperty.setValue(eUInformation);
    }
}

