/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.NetworkAddressType;
import com.prosysopc.ua.types.opcua.SelectionListType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21145")
public abstract class NetworkAddressTypeImplBase
extends BaseObjectTypeImpl
implements NetworkAddressType {
    protected NetworkAddressTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public SelectionListType getNetworkInterfaceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkInterface");
        return (SelectionListType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNetworkInterface() {
        SelectionListType selectionListType = this.getNetworkInterfaceNode();
        if (selectionListType == null) {
            return null;
        }
        Object object = selectionListType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNetworkInterface(String string) throws StatusException {
        SelectionListType selectionListType = this.getNetworkInterfaceNode();
        if (selectionListType == null) {
            throw new RuntimeException("Setting NetworkInterface failed, the Optional node does not exist)");
        }
        selectionListType.setValue(string);
    }
}

