/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessRestrictionType;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.RolePermissionType;
import com.prosysopc.ua.types.opcua.AddressSpaceFileType;
import com.prosysopc.ua.types.opcua.NamespaceMetadataType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11616")
public abstract class NamespaceMetadataTypeImplBase
extends BaseObjectTypeImpl
implements NamespaceMetadataType {
    protected NamespaceMetadataTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getNamespacePublicationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespacePublicationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getNamespacePublicationDate() {
        UaProperty uaProperty = this.getNamespacePublicationDateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setNamespacePublicationDate(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getNamespacePublicationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespacePublicationDate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getStaticStringNodeIdPatternNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticStringNodeIdPattern");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getStaticStringNodeIdPattern() {
        UaProperty uaProperty = this.getStaticStringNodeIdPatternNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setStaticStringNodeIdPattern(String string) throws StatusException {
        UaProperty uaProperty = this.getStaticStringNodeIdPatternNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticStringNodeIdPattern failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getStaticNodeIdTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNodeIdTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public IdType[] getStaticNodeIdTypes() {
        UaProperty uaProperty = this.getStaticNodeIdTypesNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (IdType[])variant.asEnum(IdType.class);
    }

    @Override
    @Mandatory
    public void setStaticNodeIdTypes(IdType[] idTypeArray) throws StatusException {
        UaProperty uaProperty = this.getStaticNodeIdTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNodeIdTypes failed, the Optional node does not exist)");
        }
        uaProperty.setValue(idTypeArray);
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceUri() {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDefaultRolePermissionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultRolePermissions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public RolePermissionType[] getDefaultRolePermissions() {
        UaProperty uaProperty = this.getDefaultRolePermissionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RolePermissionType[])object;
    }

    @Override
    @Optional
    public void setDefaultRolePermissions(RolePermissionType[] rolePermissionTypeArray) throws StatusException {
        UaProperty uaProperty = this.getDefaultRolePermissionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultRolePermissions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(rolePermissionTypeArray);
    }

    @Override
    @Optional
    public UaProperty getDefaultAccessRestrictionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultAccessRestrictions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public AccessRestrictionType getDefaultAccessRestrictions() {
        UaProperty uaProperty = this.getDefaultAccessRestrictionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AccessRestrictionType)object;
    }

    @Override
    @Optional
    public void setDefaultAccessRestrictions(AccessRestrictionType accessRestrictionType) throws StatusException {
        UaProperty uaProperty = this.getDefaultAccessRestrictionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultAccessRestrictions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(accessRestrictionType);
    }

    @Override
    @Mandatory
    public UaProperty getStaticNumericNodeIdRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNumericNodeIdRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getStaticNumericNodeIdRange() {
        UaProperty uaProperty = this.getStaticNumericNodeIdRangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setStaticNumericNodeIdRange(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getStaticNumericNodeIdRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNumericNodeIdRange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getIsNamespaceSubsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsNamespaceSubset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsNamespaceSubset() {
        UaProperty uaProperty = this.getIsNamespaceSubsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsNamespaceSubset(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getIsNamespaceSubsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsNamespaceSubset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceVersion() {
        UaProperty uaProperty = this.getNamespaceVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceVersion(String string) throws StatusException {
        UaProperty uaProperty = this.getNamespaceVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceVersion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDefaultUserRolePermissionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultUserRolePermissions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public RolePermissionType[] getDefaultUserRolePermissions() {
        UaProperty uaProperty = this.getDefaultUserRolePermissionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RolePermissionType[])object;
    }

    @Override
    @Optional
    public void setDefaultUserRolePermissions(RolePermissionType[] rolePermissionTypeArray) throws StatusException {
        UaProperty uaProperty = this.getDefaultUserRolePermissionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultUserRolePermissions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(rolePermissionTypeArray);
    }

    @Override
    @Optional
    public AddressSpaceFileType getNamespaceFileNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceFile");
        return (AddressSpaceFileType)this.getComponent(qualifiedName);
    }
}

