/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.types.opcua.MultiStateValueDiscreteType;
import com.prosysopc.ua.types.opcua.client.DiscreteItemTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11238")
public abstract class MultiStateValueDiscreteTypeImplBase
extends DiscreteItemTypeImpl
implements MultiStateValueDiscreteType {
    protected MultiStateValueDiscreteTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getEnumValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnumValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EnumValueType[] getEnumValues() {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EnumValueType[])object;
    }

    @Override
    @Mandatory
    public void setEnumValues(EnumValueType[] enumValueTypeArray) throws StatusException {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnumValues failed, the Optional node does not exist)");
        }
        uaProperty.setValue(enumValueTypeArray);
    }

    @Override
    @Mandatory
    public UaProperty getValueAsTextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValueAsText");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getValueAsText() {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setValueAsText(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValueAsText failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }
}

