/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.NamingRuleType;
import com.prosysopc.ua.types.opcua.ModellingRuleType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=77")
public abstract class ModellingRuleTypeImplBase
extends BaseObjectTypeImpl
implements ModellingRuleType {
    protected ModellingRuleTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getNamingRuleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamingRule");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NamingRuleType getNamingRule() {
        UaProperty uaProperty = this.getNamingRuleNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (NamingRuleType)variant.asEnum(NamingRuleType.class);
    }

    @Override
    @Mandatory
    public void setNamingRule(NamingRuleType namingRuleType) throws StatusException {
        UaProperty uaProperty = this.getNamingRuleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamingRule failed, the Optional node does not exist)");
        }
        uaProperty.setValue(namingRuleType);
    }
}

