/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.FileType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public abstract class FileTypeImplBase
extends BaseObjectTypeImpl
implements FileType {
    protected FileTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Writable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isWritable() {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setWritable(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Writable failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Size");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSize() {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSize(UnsignedLong unsignedLong) throws StatusException {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Size failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedLong);
    }

    @Override
    @Mandatory
    public UaProperty getOpenCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getOpenCount() {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setOpenCount(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OpenCount failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getUserWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UserWritable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isUserWritable() {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setUserWritable(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserWritable failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getMimeTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MimeType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMimeType() {
        UaProperty uaProperty = this.getMimeTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMimeType(String string) throws StatusException {
        UaProperty uaProperty = this.getMimeTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MimeType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaMethod getCloseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Close");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void close(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Close"));
        this.call(nodeId, unsignedInteger);
    }

    public AsyncResult<Void> closeAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Close"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, unsignedInteger);
    }

    @Override
    @Mandatory
    public UaMethod getWriteNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Write");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void write(UnsignedInteger unsignedInteger, ByteString byteString) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Write"));
        this.call(nodeId, unsignedInteger, byteString);
    }

    public AsyncResult<Void> writeAsync(UnsignedInteger unsignedInteger, ByteString byteString) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Write"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, unsignedInteger, byteString);
    }

    @Override
    @Mandatory
    public UaMethod getSetPositionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void setPosition(UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition"));
        this.call(nodeId, unsignedInteger, unsignedLong);
    }

    public AsyncResult<Void> setPositionAsync(UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void g(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.g(variantArray);
            }
        }, unsignedInteger, unsignedLong);
    }

    @Override
    @Mandatory
    public UaMethod getOpenNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Open");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public UnsignedInteger open(UnsignedByte unsignedByte) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Open"));
        return this.call(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger t(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.t(variantArray);
            }
        }, unsignedByte);
    }

    public AsyncResult<? extends UnsignedInteger> openAsync(UnsignedByte unsignedByte) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Open"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger t(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.t(variantArray);
            }
        }, unsignedByte);
    }

    @Override
    @Mandatory
    public UaMethod getGetPositionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public UnsignedLong getPosition(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition"));
        return this.call(nodeId, new MethodArgumentTransformer<UnsignedLong>(){

            public UnsignedLong u(Variant[] variantArray) {
                return (UnsignedLong)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, unsignedInteger);
    }

    public AsyncResult<? extends UnsignedLong> getPositionAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<UnsignedLong>(){

            public UnsignedLong u(Variant[] variantArray) {
                return (UnsignedLong)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, unsignedInteger);
    }

    @Override
    @Mandatory
    public UaMethod getReadNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Read");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public ByteString read(UnsignedInteger unsignedInteger, Integer n2) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Read"));
        return this.call(nodeId, new MethodArgumentTransformer<ByteString>(){

            public ByteString v(Variant[] variantArray) {
                return (ByteString)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.v(variantArray);
            }
        }, unsignedInteger, n2);
    }

    public AsyncResult<? extends ByteString> readAsync(UnsignedInteger unsignedInteger, Integer n2) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Read"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<ByteString>(){

            public ByteString v(Variant[] variantArray) {
                return (ByteString)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.v(variantArray);
            }
        }, unsignedInteger, n2);
    }
}

