/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.types.opcua.ExpressionGuardVariableType;
import com.prosysopc.ua.types.opcua.client.GuardVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15128")
public abstract class ExpressionGuardVariableTypeImplBase
extends GuardVariableTypeImpl
implements ExpressionGuardVariableType {
    protected ExpressionGuardVariableTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getExpressionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Expression");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ContentFilter getExpression() {
        UaProperty uaProperty = this.getExpressionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ContentFilter)object;
    }

    @Override
    @Mandatory
    public void setExpression(ContentFilter contentFilter) throws StatusException {
        UaProperty uaProperty = this.getExpressionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Expression failed, the Optional node does not exist)");
        }
        uaProperty.setValue(contentFilter);
    }
}

