/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DataTypeDictionaryType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=72")
public abstract class DataTypeDictionaryTypeImplBase
extends BaseDataVariableTypeImpl
implements DataTypeDictionaryType {
    protected DataTypeDictionaryTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getDataTypeVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataTypeVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDataTypeVersion() {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDataTypeVersion(String string) throws StatusException {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataTypeVersion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDeprecatedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Deprecated");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isDeprecated() {
        UaProperty uaProperty = this.getDeprecatedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setDeprecated(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getDeprecatedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Deprecated failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getNamespaceUri() {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setNamespaceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }
}

