/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.CertificateExpirationAlarmType;
import com.prosysopc.ua.types.opcua.CertificateGroupType;
import com.prosysopc.ua.types.opcua.TrustListOutOfDateAlarmType;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12555")
public abstract class CertificateGroupTypeImplBase
extends BaseObjectTypeImpl
implements CertificateGroupType {
    protected CertificateGroupTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getCertificateTypes() {
        UaProperty uaProperty = this.getCertificateTypesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setCertificateTypes(NodeId[] nodeIdArray) throws StatusException {
        UaProperty uaProperty = this.getCertificateTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateTypes failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeIdArray);
    }

    @Override
    @Mandatory
    public TrustListType getTrustListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustList");
        return (TrustListType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public CertificateExpirationAlarmType getCertificateExpiredNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateExpired");
        return (CertificateExpirationAlarmType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public TrustListOutOfDateAlarmType getTrustListOutOfDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustListOutOfDate");
        return (TrustListOutOfDateAlarmType)this.getComponent(qualifiedName);
    }
}

