/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.BrokerConnectionTransportType;
import com.prosysopc.ua.types.opcua.client.ConnectionTransportTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15155")
public abstract class BrokerConnectionTransportTypeImplBase
extends ConnectionTransportTypeImpl
implements BrokerConnectionTransportType {
    protected BrokerConnectionTransportTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getAuthenticationProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationProfileUri() {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationProfileUri(String string) throws StatusException {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }
}

