/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaVariableImpl;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.types.opcua.BaseVariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=62")
public class BaseVariableTypeImpl
extends UaVariableImpl
implements BaseVariableType {
    private static final Logger logger = LoggerFactory.getLogger(BaseVariableTypeImpl.class);

    public BaseVariableTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    public QualifiedName getQualifiedName(String string, String string2) {
        return new QualifiedName(this.getAddressSpace().getNamespaceTable().getIndex(string), string2);
    }

    protected Enumeration getEnumerationFromRawValue(UaVariable uaVariable) {
        Variant variant = uaVariable.getValue().getValue();
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        try {
            int n2 = variant.intValue();
            NodeId nodeId = uaVariable.getDataTypeId();
            NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
            EnumerationSpecification enumerationSpecification = this.getAddressSpace().getEncoderContext().getEnumerationSpecification(UaNodeId.fromLocal(nodeId, namespaceTable));
            if (enumerationSpecification != null) {
                return enumerationSpecification.createEnumerationFromInteger(n2);
            }
            return DynamicEnumeration.valueOf(n2);
        }
        catch (Exception exception) {
            logger.error("Could not resolve Variant {} to Enumeration", (Object)variant, (Object)exception);
            return null;
        }
    }
}

