/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.AuditSessionEventType;
import com.prosysopc.ua.types.opcua.client.AuditSecurityEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2069")
public abstract class AuditSessionEventTypeImplBase
extends AuditSecurityEventTypeImpl
implements AuditSessionEventType {
    protected AuditSessionEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SessionId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

