/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.SecurityGroupFolderType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15906")
public interface PubSubKeyServiceType
extends BaseObjectType {
    public static final String SECURITY_GROUPS = "SecurityGroups";
    public static final String GET_SECURITY_GROUP = "GetSecurityGroup";
    public static final String GET_SECURITY_KEYS = "GetSecurityKeys";

    @Optional
    public SecurityGroupFolderType getSecurityGroupsNode();

    @Optional
    public UaMethod getGetSecurityGroupNode();

    public NodeId getSecurityGroup(String var1) throws StatusException, ServiceException;

    @Optional
    public UaMethod getGetSecurityKeysNode();

    public GetSecurityKeysMethodOutputs getSecurityKeys(String var1, UnsignedInteger var2, UnsignedInteger var3) throws StatusException, ServiceException;

    public static class GetSecurityKeysMethodOutputs
    implements MethodOutputArguments {
        protected String securityPolicyUri;
        protected UnsignedInteger firstTokenId;
        protected ByteString[] keys;
        protected Double timeToNextKey;
        protected Double keyLifetime;

        public GetSecurityKeysMethodOutputs(String string, UnsignedInteger unsignedInteger, ByteString[] byteStringArray, Double d2, Double d3) {
            this.securityPolicyUri = string;
            this.firstTokenId = unsignedInteger;
            this.keys = byteStringArray;
            this.timeToNextKey = d2;
            this.keyLifetime = d3;
        }

        public String getSecurityPolicyUri() {
            return this.securityPolicyUri;
        }

        public UnsignedInteger getFirstTokenId() {
            return this.firstTokenId;
        }

        public ByteString[] getKeys() {
            return this.keys;
        }

        public Double getTimeToNextKey() {
            return this.timeToNextKey;
        }

        public Double getKeyLifetime() {
            return this.keyLifetime;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.securityPolicyUri), new Variant(this.firstTokenId), new Variant(this.keys), new Variant(this.timeToNextKey), new Variant(this.keyLifetime)};
        }
    }
}

