/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.BaseObjectType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=1020")
public interface KeyCredentialServiceType
extends BaseObjectType {
    public static final String RESOURCE_URI = "ResourceUri";
    public static final String PROFILE_URIS = "ProfileUris";
    public static final String START_REQUEST = "StartRequest";
    public static final String FINISH_REQUEST = "FinishRequest";
    public static final String REVOKE = "Revoke";

    @Mandatory
    public UaProperty getResourceUriNode();

    @Mandatory
    public String getResourceUri();

    @Mandatory
    public void setResourceUri(String var1) throws StatusException;

    @Mandatory
    public UaProperty getProfileUrisNode();

    @Mandatory
    public String[] getProfileUris();

    @Mandatory
    public void setProfileUris(String[] var1) throws StatusException;

    @Mandatory
    public UaMethod getStartRequestNode();

    public NodeId startRequest(String var1, ByteString var2, String var3, NodeId[] var4) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getFinishRequestNode();

    public FinishRequestMethodOutputs finishRequest(NodeId var1, Boolean var2) throws StatusException, ServiceException;

    @Optional
    public UaMethod getRevokeNode();

    public void revoke(String var1) throws StatusException, ServiceException;

    public static class FinishRequestMethodOutputs
    implements MethodOutputArguments {
        protected String credentialId;
        protected ByteString credentialSecret;
        protected String certificateThumbprint;
        protected String securityPolicyUri;
        protected NodeId[] grantedRoles;

        public FinishRequestMethodOutputs(String string, ByteString byteString, String string2, String string3, NodeId[] nodeIdArray) {
            this.credentialId = string;
            this.credentialSecret = byteString;
            this.certificateThumbprint = string2;
            this.securityPolicyUri = string3;
            this.grantedRoles = nodeIdArray;
        }

        public String getCredentialId() {
            return this.credentialId;
        }

        public ByteString getCredentialSecret() {
            return this.credentialSecret;
        }

        public String getCertificateThumbprint() {
            return this.certificateThumbprint;
        }

        public String getSecurityPolicyUri() {
            return this.securityPolicyUri;
        }

        public NodeId[] getGrantedRoles() {
            return this.grantedRoles;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.credentialId), new Variant(this.credentialSecret), new Variant(this.certificateThumbprint), new Variant(this.securityPolicyUri), new Variant(this.grantedRoles)};
        }
    }
}

